/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.actions.AbstractPerformOperationActionDelegate;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ops.IOperationUIDelegate;
import com.ibm.cics.eclipse.common.ops.PerformActionDialog;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractPerformOperationAction<T>
extends Action {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AbstractPerformOperationAction.class);
    private final IWorkbenchPart targetPart;
    private final List<? extends T> targets;

    public AbstractPerformOperationAction(List<? extends T> targets, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
        this.targets = targets;
    }

    protected abstract IOperationUIDelegate<? super T> getOperationUIDelegate() throws AbstractPerformOperationActionDelegate.CICSObjectActionException;

    public void run() {
        block9: {
            debug.enter(((Object)((Object)this)).getClass().getName(), (Object)"run", (Object)this);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (this.targetPart != null) {
                ViewHelper.setTargetPart((IWorkbenchPart)this.targetPart);
            }
            try {
                try {
                    IOperationUIDelegate<T> operationUIDelegate = this.getOperationUIDelegate();
                    PerformActionDialog wizard = new PerformActionDialog(shell, operationUIDelegate, this.targets);
                    wizard.setBlockOnOpen(true);
                    wizard.open();
                }
                catch (AbstractPerformOperationActionDelegate.CICSObjectActionException ex) {
                    debug.error(((Object)((Object)this)).getClass().getName(), "run", (Throwable)ex);
                    if (this.targetPart != null) {
                        ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (this.targetPart != null) {
                    ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
                }
                throw throwable;
            }
            if (this.targetPart != null) {
                ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
            }
        }
        debug.exit(((Object)((Object)this)).getClass().getName(), (Object)"run");
    }
}

