/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.OperationTypesWrapper;
import com.ibm.cics.eclipse.common.historical.HistoricalApplicationOperationAdapter;
import com.ibm.cics.eclipse.common.historical.IHistoricalOperation;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.core.runtime.IAdapterFactory;

public class HistoricalApplicationFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(HistoricalApplicationFactory.class);
    private static final Class[] ADAPTER_TYPES = new Class[]{IHistoricalOperation.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof OperationTypesWrapper && adapterType.equals(IHistoricalOperation.class)) {
            try {
                ICoreObject coreObject = (ICoreObject)((OperationTypesWrapper)adaptableObject).getApplication();
                ICPSM cpsm = coreObject.getCPSM();
                if (cpsm != null) {
                    ICICSplex[] cicsplexes;
                    ICICSplex[] iCICSplexArray = cicsplexes = cpsm.getCICSplexes();
                    int n = cicsplexes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICICSObject[] cicsObjects;
                        ICICSplex plex = iCICSplexArray[n2];
                        Context context = new Context(plex.getName());
                        ICICSObject[] iCICSObjectArray = cicsObjects = cpsm.getDefinitions2((ICICSType)PlatformType.getInstance(), (IContext)context);
                        int n3 = cicsObjects.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICICSObject cicsObject = iCICSObjectArray[n4];
                            if (cicsObject instanceof IPlatform && ((IPlatform)cicsObject).getPlatformDefinitionName().equals(((IApplication)coreObject).getPlatformDefinitionName())) {
                                OperationTypesWrapper operationWrapper = (OperationTypesWrapper)adaptableObject;
                                IApplication application = operationWrapper.getApplication();
                                return new HistoricalApplicationOperationAdapter(((IPlatform)cicsObject).getName(), application.getName(), application.getMajorVersion().intValue(), application.getMinorVersion().intValue(), application.getMicroVersion().intValue(), operationWrapper.getOperationName());
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            catch (CICSSystemManagerException e) {
                debug.error("getAdapter", (Throwable)e);
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_TYPES;
    }
}

