/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.ui.properties.CICSAttributeLabelProvider;
import com.ibm.cics.model.ICICSDefinition;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class CICSDefinitionDecorator
implements ILightweightLabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CICSAttributeLabelProvider versionLabelProvider = new CICSAttributeLabelProvider(AbstractCICSDefinitionType.VERSION);
    private CICSAttributeLabelProvider csdLabelProvider = new CICSAttributeLabelProvider(AbstractCICSDefinitionType.CSDGROUP);

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ICICSDefinition) {
            ICICSDefinition cicsDefinition = (ICICSDefinition)element;
            if (cicsDefinition.getVersion() != 0L) {
                decoration.addSuffix(" " + this.versionLabelProvider.getText(cicsDefinition.getVersion()));
            } else {
                decoration.addSuffix(" " + this.csdLabelProvider.getText(cicsDefinition.getCSDGroup()));
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

