/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.UnsupportedTypeException;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;

public abstract class RootDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(AbstractRegionTypeDeferredWorkbenchAdapter.class);
    private final ICICSType<? extends ICICSObject> objectType;
    private final ICICSType<? extends ICICSObject> definitionType;

    public RootDeferredWorkbenchAdapter(CloudInput cloudInput, ICICSType<? extends ICICSObject> objectType, ICICSType<? extends ICICSObject> definitionType) {
        super(cloudInput);
        this.objectType = objectType;
        this.definitionType = definitionType;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        Object[] objectDefinitions;
        Object[] objects;
        DEBUG.enter("getDataChildren", (Object)this, o);
        IContext context = this.getContext();
        try {
            objects = this.getObjects(context);
        }
        catch (SystemManagerConnectionException e) {
            objects = new Object[]{new ErrorWrapper(e)};
        }
        try {
            objectDefinitions = this.getObjectDefinitions(context);
        }
        catch (SystemManagerConnectionException e) {
            objectDefinitions = new Object[]{new ErrorWrapper(e)};
        }
        Object[] children = this.getMergedDefinitionsAndObjects(objects, objectDefinitions);
        DEBUG.exit("getDataChildren", (Object)Arrays.toString(children));
        return children;
    }

    private Object[] getMergedDefinitionsAndObjects(Object[] objects, Object[] objectDefinitions) {
        ArrayList<Object> objectsAndDefinitions = objectDefinitions == null || objectDefinitions.length == 1 && !(objectDefinitions[0] instanceof IDefinition) || objects.length == 1 && !(objects[0] instanceof IPlatform) && !(objects[0] instanceof IApplication) ? new ArrayList<Object>(Arrays.asList(objects)) : new ArrayList(objectDefinitions.length);
        Object[] objectArray = objectDefinitions;
        int n = objectDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectDef = objectArray[n2];
            if (objectDef instanceof IDefinition) {
                IDefinition def = (IDefinition)objectDef;
                boolean installed = false;
                Object[] objectArray2 = objects;
                int n3 = objects.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray2[n4];
                    if (object instanceof ICICSObject && this.isDefinitionForObject(def, (ICICSObject)object)) {
                        installed = true;
                        objectsAndDefinitions.add(object);
                        break;
                    }
                    ++n4;
                }
                if (!installed) {
                    objectsAndDefinitions.add(def);
                }
            } else {
                objectsAndDefinitions.add(objectDef);
            }
            ++n2;
        }
        return objectsAndDefinitions.toArray();
    }

    private ICICSObject[] getObjects(IContext context) throws SystemManagerConnectionException {
        ICICSObject[] results = new ICICSObject[]{};
        try {
            results = this.getCICSObjects(this.objectType, context);
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() instanceof UnsupportedTypeException) {
                DEBUG.event("getObjects, type " + ((UnsupportedTypeException)e.getCause()).getResourceTableName() + " unsupported", (Object)e);
            }
            if (e.getCause() != null && e.getCause() instanceof SystemManagerConnectionException) {
                DEBUG.event("getObjects", (Object)e);
                throw (SystemManagerConnectionException)e.getCause();
            }
            DEBUG.error("getObjects", (Throwable)e);
        }
        return results;
    }

    private ICICSObject[] getObjectDefinitions(IContext context) throws SystemManagerConnectionException {
        ICICSObject[] results = new ICICSObject[]{};
        try {
            results = this.getCICSObjects(this.definitionType, context);
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() instanceof UnsupportedTypeException) {
                DEBUG.event("getObjectDefinitions, type " + ((UnsupportedTypeException)e.getCause()).getResourceTableName() + " unsupported", (Object)e);
            }
            if (e.getCause() != null && e.getCause() instanceof SystemManagerConnectionException) {
                DEBUG.event("getObjectDefinitions", (Object)e);
                throw (SystemManagerConnectionException)e.getCause();
            }
            DEBUG.error("getObjectDefinitions", (Throwable)e);
        }
        return results;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.getCloudInput().getCICSPlexName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    protected abstract boolean isDefinitionForObject(IDefinition var1, ICICSObject var2);

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_objects, null);
    }
}

