/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.CICSTypePropertySource;
import com.ibm.cics.core.ui.properties.AttributePropertyHelper;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.MultiSourcePropertySourceProvider;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.meta.IType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class CICSObjectMultiPropertySourceProvider
extends MultiSourcePropertySourceProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map<ICICSType<?>, CICSTypePropertySource> typePropertySources = new HashMap();
    private final Map<Object, IPropertyDescriptor> propertyIdsToPropertyDescriptors;
    private final Map<Object, ICICSType<?>> propertyIdsToPropertySourceIds;

    public CICSObjectMultiPropertySourceProvider(ICICSType<?> ... types) {
        super(CICSObjectMultiPropertySourceProvider.createCICSTypeSet(types));
        HashMap<Object, IAttributePropertyDescriptor> propertyIdsToPropertyDescriptors = new HashMap<Object, IAttributePropertyDescriptor>();
        HashMap propertyIdsToPropertySourceIds = new HashMap();
        ICICSType<?>[] iCICSTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSType<?> type = iCICSTypeArray[n2];
            CICSTypePropertySource typePropertySource = new CICSTypePropertySource(type);
            this.typePropertySources.put(type, typePropertySource);
            IAttributePropertyDescriptor[] iAttributePropertyDescriptorArray = typePropertySource.getPropertyDescriptors();
            int n3 = iAttributePropertyDescriptorArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAttributePropertyDescriptor propertyDescriptor = iAttributePropertyDescriptorArray[n4];
                propertyIdsToPropertyDescriptors.put(propertyDescriptor.getId(), propertyDescriptor);
                propertyIdsToPropertySourceIds.put(propertyDescriptor.getId(), type);
                ++n4;
            }
            ++n2;
        }
        this.propertyIdsToPropertyDescriptors = Collections.unmodifiableMap(propertyIdsToPropertyDescriptors);
        this.propertyIdsToPropertySourceIds = Collections.unmodifiableMap(propertyIdsToPropertySourceIds);
    }

    private static Collection<? extends ICICSType<?>> createCICSTypeSet(ICICSType<?> ... cicsTypes) {
        HashSet set = new HashSet();
        ICICSType<?>[] iCICSTypeArray = cicsTypes;
        int n = cicsTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSType<?> cicsType = iCICSTypeArray[n2];
            set.add(cicsType);
            ++n2;
        }
        return set;
    }

    @Override
    protected IPropertySource createPropertySource(Object propertySourceId, Object object) {
        if (propertySourceId instanceof ICICSType && ((ICICSType)propertySourceId).getInterfaceType().isAssignableFrom(object.getClass())) {
            ICICSObject cicsObject = (ICICSObject)((ICICSType)propertySourceId).getInterfaceType().cast(object);
            final CICSTypePropertySource typePropertySource = this.typePropertySources.get(propertySourceId);
            if (typePropertySource != null) {
                return new CICSObjectPropertySource(cicsObject){

                    @Override
                    protected AttributePropertyHelper createHelper(IType<?> objectType, Class<?> interfaceType) {
                        return typePropertySource;
                    }
                };
            }
        }
        return null;
    }

    @Override
    public Map<Object, IPropertyDescriptor> getPropertyDescriptorMap() {
        return this.propertyIdsToPropertyDescriptors;
    }

    @Override
    protected Object getPropertySourceId(Object propertyId) {
        return this.propertyIdsToPropertySourceIds.get(propertyId);
    }
}

