/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.ui.adapters.InstallTargetWorkbenchAdapter;
import com.ibm.cics.core.ui.adapters.RepositoryWorkbenchAdapter;
import com.ibm.cics.core.ui.adapters.RootRepositoriesWorkbenchAdapter;
import com.ibm.cics.core.ui.views.AbstractResourcesTreeView;
import com.ibm.cics.model.CICSRegionDefinitionInstallTarget;
import com.ibm.cics.model.CICSRegionGroupDefinitionInstallTarget;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.InstallTarget;
import com.ibm.cics.sm.comm.CSDRepository;
import com.ibm.cics.sm.comm.DREPRepository;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;

public class RepositoryExplorerView
extends AbstractResourcesTreeView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String ID = "com.ibm.cics.core.ui.view.repositoryExplorer";

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof RepositoryWorkbenchAdapter && e2 instanceof RepositoryWorkbenchAdapter) {
                    IRepository r1 = ((RepositoryWorkbenchAdapter)e1).getRepository();
                    IRepository r2 = ((RepositoryWorkbenchAdapter)e2).getRepository();
                    if (r1 instanceof DREPRepository && r2 instanceof CSDRepository) {
                        return -1;
                    }
                    if (r2 instanceof DREPRepository && r1 instanceof CSDRepository) {
                        return 1;
                    }
                    return super.compare(viewer, (Object)r1, (Object)r2);
                }
                if (e1 instanceof InstallTargetWorkbenchAdapter && e2 instanceof InstallTargetWorkbenchAdapter) {
                    InstallTarget t1 = ((InstallTargetWorkbenchAdapter)e1).getInstallTarget();
                    InstallTarget t2 = ((InstallTargetWorkbenchAdapter)e2).getInstallTarget();
                    if (t1 instanceof CICSRegionDefinitionInstallTarget && t2 instanceof CICSRegionGroupDefinitionInstallTarget) {
                        return -1;
                    }
                    if (t2 instanceof CICSRegionGroupDefinitionInstallTarget && t1 instanceof CICSRegionDefinitionInstallTarget) {
                        return 1;
                    }
                    return super.compare(viewer, (Object)t1, (Object)t2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    @Override
    protected String getHelpContextID() {
        return "com.ibm.cics.core.ui.view_repositoryExplorer";
    }

    @Override
    public TreeViewer createTreeViewer(Composite parent) {
        PatternFilter patternFilter = new PatternFilter();
        patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filter = new FilteredTree(parent, 770, patternFilter, true);
        return filter.getViewer();
    }

    @Override
    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        if (element instanceof ICPSM) {
            return new RootRepositoriesWorkbenchAdapter((ICPSM)element);
        }
        return null;
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new RepoLabelProvider();
    }

    @Override
    protected void fillContextMenu(IMenuManager aMenuManager) {
    }

    class RepoLabelProvider
    extends LabelProvider {
        RepoLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof IDeferredWorkbenchAdapter) {
                return ((IDeferredWorkbenchAdapter)object).getLabel(object);
            }
            return object.toString();
        }

        public Image getImage(Object object) {
            ImageDescriptor imageDescriptor = null;
            if (object instanceof IDeferredWorkbenchAdapter) {
                imageDescriptor = ((IDeferredWorkbenchAdapter)object).getImageDescriptor(object);
            }
            return imageDescriptor == null ? null : imageDescriptor.createImage();
        }
    }
}

