/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.views.Messages;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ResourcesViewJobs {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourcesViewJobs.class.getPackage().getName());
    private static final com.ibm.cics.common.util.Debug debug = new com.ibm.cics.common.util.Debug(ResourcesViewJobs.class);

    private static String formatJobName(String jobName, String resourceName) {
        return String.valueOf(jobName) + ": " + resourceName;
    }

    public static class ActivateJob
    extends ResourcesModelJob {
        private final IResourcesModel model;

        public ActivateJob(IResourcesModel model) {
            super(ResourcesViewJobs.formatJobName(Messages.getString("ResourcesView.job.activate.name", new Object[0]), model.getResourceName()), model);
            this.model = model;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"ActivateJob.run", (Object)((Object)this), (Object)Thread.currentThread().getName());
            monitor.beginTask(this.getName(), -1);
            try {
                this.model.activate();
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"ActivateJob.run");
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public IResourcesModel getModel() {
            return this.model;
        }
    }

    public static class DisposeJob
    extends ResourcesModelJob {
        private IResourcesModel model;

        public DisposeJob(IResourcesModel model) {
            super(ResourcesViewJobs.formatJobName(Messages.getString("ResourcesView.job.disposejob.name", new Object[0]), model.getResourceName()), model);
            this.model = model;
            this.setUser(false);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            if (Debug.DEBUG_RESOURCES) {
                Debug.event((Logger)logger, (String)DisposeJob.class.getName(), (String)"run", (Object)("model=" + this.model));
            }
            monitor.beginTask(this.getName(), -1);
            try {
                this.model.dispose();
                if (Debug.DEBUG_RESOURCES) {
                    Debug.event((Logger)logger, (String)DisposeJob.class.getName(), (String)"run");
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public IResourcesModel getModel() {
            return this.model;
        }
    }

    public static class GetJob
    extends ResourcesModelJob {
        private final IResourcesModel model;
        private final int topIndex;
        private final int count;
        private final boolean reactivate;

        public GetJob(IResourcesModel model, boolean reactivate, int topIndex, int count) {
            super(ResourcesViewJobs.formatJobName(Messages.getString("ResourcesView.job.get.name", new Object[0]), model.getResourceName()), model);
            this.model = model;
            this.reactivate = reactivate;
            this.topIndex = topIndex;
            this.count = count;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            try {
                if (this.reactivate) {
                    this.model.reactivate();
                }
                this.model.maybeFetch(this.topIndex, this.count);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        protected void canceling() {
            debug.event("cancelling", (Object)this);
        }

        @Override
        public IResourcesModel getModel() {
            return this.model;
        }
    }

    public static abstract class ResourcesModelJob
    extends Job {
        private final IResourcesModel model;

        public ResourcesModelJob(String jobName, IResourcesModel model) {
            super(jobName);
            this.model = model;
        }

        public IResourcesModel getModel() {
            return this.model;
        }

        protected final IStatus run(IProgressMonitor monitor) {
            if (!this.model.isDisposed()) {
                return this.doRun(monitor);
            }
            return Status.OK_STATUS;
        }

        protected abstract IStatus doRun(IProgressMonitor var1);
    }
}

