/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.CSDListDefinitionAssociationContext;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICICSplexRepository;
import com.ibm.cics.core.model.IChild;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.IStrategicContextProvider;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.model.context.IAssociationContextProvider;
import com.ibm.cics.core.model.context.ICMASContextProvider;
import com.ibm.cics.core.model.context.IWorkloadContextProvider;
import com.ibm.cics.core.ui.OperationTypesWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadRouter;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import com.ibm.cics.sm.comm.context.IWorkloadContext;
import com.ibm.cics.sm.comm.context.WorkloadContext;
import org.eclipse.core.runtime.IAdapterFactory;

public class ContextProviderAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ContextProviderAdapterFactory.class);
    private static final ICMASContextProvider cicsPlexCMASContextAdapter = new ICMASContextProvider(){

        public ICMASContext getIContext(ICICSObject object) {
            final ICICSplex cicsPlex = (ICICSplex)object;
            return new ICMASContext(){

                public String getContext() {
                    return cicsPlex.getCMASName();
                }

                public String toString() {
                    return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "]";
                }
            };
        }

        public String toString() {
            return "ICMASContextProvider[cicsPlexCMASContextAdapter]";
        }
    };
    private static final ICMASContextProvider managedRegionCMASContextAdapter = new ICMASContextProvider(){

        public ICMASContext getIContext(ICICSObject object) {
            IManagedRegion managedRegion = (IManagedRegion)object;
            IChild child = (IChild)managedRegion;
            final ICICSplex cicsPlex = (ICICSplex)child.getParent();
            return new ICMASContext(){

                public String getContext() {
                    return cicsPlex.getCMASName();
                }

                public String toString() {
                    return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "]";
                }
            };
        }

        public String toString() {
            return "ICMASContextProvider[managedRegionCMASContextAdapter]";
        }
    };
    private static final ICMASContextProvider cicsPlexRepositoryCMASContextAdapter = new ICMASContextProvider(){

        public ICMASContext getIContext(ICICSObject object) {
            ICICSplexRepository repository = (ICICSplexRepository)object;
            final ICICSplex cicsPlex = repository.getCICSplex();
            return new ICMASContext(){

                public String getContext() {
                    return cicsPlex.getCMASName();
                }

                public String toString() {
                    return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "]";
                }
            };
        }

        public String toString() {
            return "ICMASContextProvider[cicsPlexRepositoryCMASContextAdapter]";
        }
    };
    private static final IAssociationContextProvider csdListDefinitionAssociationContextAdapter = new IAssociationContextProvider(){

        public IAssociationContext getContext(ICICSObject object) {
            return new CSDListDefinitionAssociationContext((ICSDListDefinition)object);
        }

        public String toString() {
            return "IAssociationContextProvider[csdListDefinitionAssociationContextAdapter]";
        }
    };
    private static final IAssociationContextProvider resourceDescriptionDefinitionAssociationContextAdapter = new IAssociationContextProvider(){

        public IAssociationContext getContext(ICICSObject object) {
            final IResourceDescriptionDefinition definition = (IResourceDescriptionDefinition)object;
            return new IAssociationContext(){

                public String getContext() {
                    ICoreObject coreObject = (ICoreObject)definition;
                    IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
                    return primaryKey.getContext();
                }

                public String getResourceType() {
                    return definition.getObjectType().getResourceTableName();
                }

                public String getResourceName() {
                    return definition.getName();
                }

                public boolean equals(Object o) {
                    if (o == null) {
                        return false;
                    }
                    return this.toString().equals(o.toString());
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    return String.valueOf(this.getClass().getName()) + "[" + this.getContext() + "/" + this.getResourceType() + "=" + this.getResourceName() + "]";
                }
            };
        }

        public String toString() {
            return "IAssociationContextProvider[resourceDescriptionDefinitionAssociationContextAdapter]";
        }
    };

    public ContextProviderAdapterFactory() {
        debug.event("<init>", (Object)this);
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        debug.enter("getAdapter", (Object)this, adaptableObject, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IAssociationContextProvider.class) {
            if (adaptableObject instanceof ICSDListDefinition) {
                adapter = csdListDefinitionAssociationContextAdapter;
            } else if (adaptableObject instanceof IResourceDescriptionDefinition) {
                adapter = resourceDescriptionDefinitionAssociationContextAdapter;
            }
        } else if (adapterType == ICMASContextProvider.class) {
            if (adaptableObject instanceof ICICSplex) {
                adapter = cicsPlexCMASContextAdapter;
            } else if (adaptableObject instanceof IManagedRegion) {
                adapter = managedRegionCMASContextAdapter;
            } else if (adaptableObject instanceof ICICSplexRepository) {
                adapter = cicsPlexRepositoryCMASContextAdapter;
            }
        } else if (adapterType == IWorkloadContextProvider.class) {
            if (adaptableObject instanceof IWorkload) {
                adapter = new WLMActiveWorkloadWorkloadContextProvider((IWorkload)adaptableObject);
            }
        } else if (adapterType == IContextProvider.class) {
            if (adaptableObject instanceof ICICSplex) {
                adapter = new CICSplexContextProvider((ICICSplex)adaptableObject);
            } else if (adaptableObject instanceof IWorkload) {
                adapter = new WLMActiveWorkloadScopedContextProvider((IWorkload)adaptableObject);
            } else if (adaptableObject instanceof IWorkloadTarget) {
                adapter = new WLMActiveAORContextProvider((IWorkloadTarget)adaptableObject);
            } else if (adaptableObject instanceof IWorkloadRouter) {
                adapter = new WLMActiveTORContextProvider((IWorkloadRouter)adaptableObject);
            } else if (adaptableObject instanceof IPlatform) {
                adapter = new PlatformContextProvider((IPlatform)adaptableObject);
            } else if (adaptableObject instanceof IApplication) {
                adapter = new ApplicationContextProvider((IApplication)adaptableObject);
            } else if (adaptableObject instanceof OperationTypesWrapper) {
                adapter = new OperationContextProvider((OperationTypesWrapper)adaptableObject);
            } else if (adaptableObject instanceof IContextProvider) {
                adapter = (IContextProvider)adaptableObject;
            }
        }
        debug.exit("getAdapter", adapter);
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{ICMASContextProvider.class};
    }

    private final class ApplicationContextProvider
    implements IContextProvider {
        private final IContext context;

        public ApplicationContextProvider(IApplication application) {
            String platformDefinition = application.getPlatformDefinitionName();
            IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)application).getAdapter(IPrimaryKey.class);
            this.context = new ScopedContext(primaryKey.getContext(), platformDefinition);
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }
    }

    private final class CICSplexContextProvider
    implements IContextProvider {
        private final IContext context;

        public CICSplexContextProvider(ICICSplex cicsPlex) {
            this.context = cicsPlex.getCMASName().equals(CICSplexType.CMAS_NAME.getUnsupportedValue()) ? new ScopedContext(cicsPlex.getName(), cicsPlex.getName()) : ((IContextProvider)cicsPlex).getIContext();
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }
    }

    private final class OperationContextProvider
    implements IContextProvider {
        private final IContext context;

        public OperationContextProvider(OperationTypesWrapper operation) {
            IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)operation.getCicsResourceWithOperation()).getAdapter(IPrimaryKey.class);
            this.context = new ScopedContext(primaryKey.getContext(), operation.getApplication().getPlatformDefinitionName());
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }
    }

    private final class PlatformContextProvider
    implements IStrategicContextProvider,
    IContextProvider {
        private final IContext context;

        public PlatformContextProvider(IPlatform platform) {
            String platformDefinition = platform.getPlatformDefinitionName();
            IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)platform).getAdapter(IPrimaryKey.class);
            this.context = new ScopedContext(primaryKey.getContext(), platformDefinition);
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }

        public IContext getStrategicIContext(ICICSType<?> elementType) {
            if (ICICSDefinition.class.isAssignableFrom(elementType.getInterfaceType())) {
                return new Context(this.context.getContext());
            }
            return this.getIContext();
        }
    }

    private final class WLMActiveAORContextProvider
    implements IContextProvider {
        private final IScopedContext context;

        public WLMActiveAORContextProvider(IWorkloadTarget activeAOR) {
            ICoreObject coreObject = (ICoreObject)activeAOR;
            IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
            this.context = new ScopedContext(primaryKey.getContext(), activeAOR.getName());
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }
    }

    private final class WLMActiveTORContextProvider
    implements IContextProvider {
        private final IScopedContext context;

        public WLMActiveTORContextProvider(IWorkloadRouter activeTOR) {
            ICoreObject coreObject = (ICoreObject)activeTOR;
            IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
            this.context = new ScopedContext(primaryKey.getContext(), activeTOR.getName());
        }

        public IContext getIContext() {
            return this.context;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.context + "]";
        }
    }

    private final class WLMActiveWorkloadScopedContextProvider
    implements IContextProvider {
        private IScopedContext scopedContext;

        public WLMActiveWorkloadScopedContextProvider(IWorkload activeWorkload) {
            ICoreObject coreObject = (ICoreObject)activeWorkload;
            IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
            this.scopedContext = new ScopedContext(primaryKey.getContext(), activeWorkload.getDefaultTargetScope());
        }

        public IContext getIContext() {
            return this.scopedContext;
        }
    }

    private final class WLMActiveWorkloadWorkloadContextProvider
    implements IWorkloadContextProvider {
        private final IWorkloadContext workloadContext;

        public WLMActiveWorkloadWorkloadContextProvider(IWorkload activeWorkload) {
            ICoreObject coreObject = (ICoreObject)activeWorkload;
            IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
            this.workloadContext = new WorkloadContext((IContext)new Context(primaryKey.getContext()), activeWorkload.getName());
        }

        public IWorkloadContext getIContext() {
            return this.workloadContext;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[" + this.workloadContext + "]";
        }
    }
}

