/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.model.ScopedContext;
import com.ibm.cics.core.ui.internal.cloud.AbstractApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.core.ui.views.ResourcesViewJobs;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public abstract class AbstractCPSMDeferredWorkbenchAdapter
implements IDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ErrorWrapper errorWrapper = null;
    private IModelListener exceptionListener = new IModelListener(){

        public void sizeChanged(int newSize, int newTotalSize) {
        }

        public void exceptionOccured(Exception exception) {
            if (exception.getCause() != null) {
                AbstractCPSMDeferredWorkbenchAdapter.this.errorWrapper = new ErrorWrapper(exception.getCause());
            } else {
                AbstractCPSMDeferredWorkbenchAdapter.this.errorWrapper = new ErrorWrapper(exception);
            }
        }

        public void contentsRemoved(ICICSObject element) {
        }

        public void contentsInvalid() {
        }

        public void contentsChanged(int firstIndex, int lastIndex) {
        }
    };
    private IModelListener cloudModelListener = new IModelListener(){

        public void sizeChanged(int newSize, int newTotalSize) {
            this.refreshThis();
        }

        public void contentsChanged(int firstIndex, int lastIndex) {
            this.refreshThis();
        }

        public void contentsRemoved(ICICSObject element) {
            this.refreshThis();
        }

        public void contentsInvalid() {
            this.refreshThis();
        }

        public void exceptionOccured(Exception exception) {
            this.refreshThis();
        }

        private void refreshThis() {
            AbstractCPSMDeferredWorkbenchAdapter adapter = AbstractCPSMDeferredWorkbenchAdapter.this.getOuterClass();
            if (adapter instanceof AbstractApplicationDeferredWorkbenchAdapter) {
                IApplication application = ((AbstractApplicationDeferredWorkbenchAdapter)adapter).application;
                AbstractCPSMDeferredWorkbenchAdapter.this.cloudInput.getCloudExplorer().refresh(application);
            } else {
                AbstractCPSMDeferredWorkbenchAdapter.this.cloudInput.getCloudExplorer().refresh(AbstractCPSMDeferredWorkbenchAdapter.this);
            }
        }
    };
    private static Debug DEBUG = new Debug(AbstractCPSMDeferredWorkbenchAdapter.class);
    private final CloudInput cloudInput;
    private HashMap<ICICSType<?>, IResourcesModel> models = new HashMap();

    public final Object[] getChildren(Object o) {
        Object[] dataChildren = this.getDataChildren(o);
        if (this.errorWrapper == null) {
            return dataChildren;
        }
        Object[] dataAndError = new Object[dataChildren.length + 1];
        System.arraycopy(dataChildren, 0, dataAndError, 0, dataChildren.length);
        dataAndError[dataChildren.length] = this.errorWrapper;
        return dataAndError;
    }

    public abstract Object[] getDataChildren(Object var1);

    public AbstractCPSMDeferredWorkbenchAdapter(CloudInput aCloudInput) {
        this.cloudInput = aCloudInput;
    }

    protected ICPSM getCPSM() {
        return this.cloudInput.getCpsm();
    }

    protected CloudInput getCloudInput() {
        return this.cloudInput;
    }

    protected AbstractCPSMDeferredWorkbenchAdapter getOuterClass() {
        return this;
    }

    protected IContext getContext() {
        DEBUG.enter("getContext", (Object)this);
        Context context = null;
        context = new Context(this.cloudInput.getCICSPlexName());
        DEBUG.exit("getContext", (Object)context);
        return context;
    }

    public abstract String getDecorateText(IDecorationContext var1);

    protected <T> FilteredContext getFilteredContextForAttribute(IContext context, ICICSAttribute<? super T> attribute, T value) {
        DEBUG.enter("getFilteredContextForAttribute", (Object)this, (Object)context, attribute, value);
        ScopedContext scopedContext = new ScopedContext(context, null);
        FilteredContext filteredContext = new FilteredContext((IContext)scopedContext);
        filteredContext.setAttributeValue(attribute, value);
        DEBUG.exit("getFilteredContextForAttribute", (Object)filteredContext);
        return filteredContext;
    }

    protected ICICSObject[] getCICSObjectsWithoutListeners(ICICSType<?> type, IContext context) throws CICSSystemManagerException {
        DEBUG.enter("getCICSObjects", type, (Object)context);
        try {
            ICICSObject[] iCICSObjectArray = this.getCPSM().getDefinitions2(type, context);
            return iCICSObjectArray;
        }
        finally {
            DEBUG.exit("getCICSObjects");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICICSObject[] getCICSObjects(ICICSType<?> type, IContext context) throws CICSSystemManagerException {
        DEBUG.enter("getCICSObjects", type, (Object)context);
        this.errorWrapper = null;
        IResourcesModel model = this.getModelForTypeAndContext(type, context);
        int size = model.size();
        model.maybeFetch(0, size);
        ICICSObject[] response = new ICICSObject[]{};
        IResourcesModel iResourcesModel = model;
        synchronized (iResourcesModel) {
            if (!model.isDisposed()) {
                response = new ICICSObject[size];
                int index = 0;
                while (index < size) {
                    response[index] = model.get(index);
                    ++index;
                }
            }
        }
        model.addListener(this.cloudModelListener);
        DEBUG.exit("getCICSObjects");
        return response;
    }

    IResourcesModel getModelForTypeAndContext(ICICSType<?> type, IContext context) {
        DEBUG.enter("getModelForTypeAndContext", type, (Object)context);
        IResourcesModel model = this.models.get(type);
        if (model != null) {
            if (!model.getContext().toString().equals(context.toString())) {
                throw new RuntimeException("Invalid attempt to use adapter with different contexts for the same CICSType");
            }
            this.models.remove(type);
            this.disposeModel(model);
        }
        model = this.getCPSM().getModel(type, context);
        this.models.put(type, model);
        model.addListener(this.exceptionListener);
        model.activate();
        DEBUG.exit("getModelForTypeAndContext", (Object)model);
        return model;
    }

    protected abstract String getFetchingName();

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        DEBUG.enter("fetchDeferredChildren", (Object)this, object, (Object)collector);
        monitor.beginTask(String.valueOf(NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_Fetching, null)) + " " + this.getFetchingName(), -1);
        try {
            if (monitor.isCanceled()) {
                DEBUG.event("fetchDeferredChildren", "monitor is canceled before get");
                return;
            }
            Object[] children = this.getChildren(object);
            if (monitor.isCanceled()) {
                DEBUG.event("fetchDeferredChildren", "monitor is canceled");
            } else {
                collector.add(children, monitor);
            }
        }
        finally {
            monitor.done();
            DEBUG.exit("fetchDeferredChildren");
        }
    }

    public void dispose() {
        Collection<IResourcesModel> values = this.models.values();
        for (IResourcesModel model : values) {
            this.disposeModel(model);
        }
        this.models.clear();
    }

    private void disposeModel(IResourcesModel model) {
        model.removeListener(this.cloudModelListener);
        model.removeListener(this.exceptionListener);
        new ResourcesViewJobs.DisposeJob(model).schedule();
    }
}

