/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.ui.IPlatformProvider;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;

final class PlatformAppsNodeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter
implements IPlatformProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(PlatformAppsNodeDeferredWorkbenchAdapter.class);
    private final IPlatform platform;

    PlatformAppsNodeDeferredWorkbenchAdapter(CloudInput anInput, IPlatform aPlatform) {
        super(anInput);
        DEBUG.enter("constructor", (Object)this, (Object)aPlatform);
        this.platform = aPlatform;
        DEBUG.exit("constructor");
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = NLS.bind((String)CloudMessages.ApplicationsNodeName, null);
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = UIPlugin.IMGD_APPLICATION_GROUP;
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        Object[] applicationDefinitions;
        Object[] applications;
        DEBUG.enter("getDataChildren", (Object)this, o);
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), ApplicationType.PLATFORM_DEFINITION_NAME, this.platform.getPlatformDefinitionName());
        try {
            applications = this.getApplicationsForPlatform(filteredContext);
        }
        catch (SystemManagerConnectionException e) {
            applications = new Object[]{new ErrorWrapper(e)};
        }
        try {
            applicationDefinitions = this.getApplicationDefinitionsForPlatform(filteredContext);
        }
        catch (SystemManagerConnectionException e) {
            applicationDefinitions = new Object[]{new ErrorWrapper(e)};
        }
        Object[] results = this.getMergedDefinitionsAndApplications(applications, applicationDefinitions);
        DEBUG.exit("getDataChildren", (Object)results);
        return results;
    }

    private Object[] getMergedDefinitionsAndApplications(Object[] applications, Object[] applicationDefinitions) {
        ArrayList<Object> applicationsAndDefinitions = new ArrayList<Object>(Arrays.asList(applications));
        Object[] objectArray = applicationDefinitions;
        int n = applicationDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            Object objectDef = objectArray[n2];
            if (objectDef instanceof IApplicationDefinition) {
                IApplicationDefinition def = (IApplicationDefinition)objectDef;
                boolean installed = false;
                Object[] objectArray2 = applications;
                int n3 = applications.length;
                int n4 = 0;
                while (n4 < n3) {
                    IApplication application;
                    Object object = objectArray2[n4];
                    if (object instanceof IApplication && this.isDefinitionForApplication(def, application = (IApplication)object)) {
                        installed = true;
                        break;
                    }
                    ++n4;
                }
                if (!installed) {
                    applicationsAndDefinitions.add(objectDef);
                }
            } else {
                applicationsAndDefinitions.add(objectDef);
            }
            ++n2;
        }
        return applicationsAndDefinitions.toArray();
    }

    private ICICSObject[] getApplicationsForPlatform(FilteredContext filteredContext) throws SystemManagerConnectionException {
        ICICSObject[] results;
        block2: {
            DEBUG.enter("getApplicationsForPlatform", (Object)this, (Object)filteredContext);
            results = new ICICSObject[]{};
            try {
                results = this.getCICSObjects((ICICSType<?>)ApplicationType.getInstance(), (IContext)filteredContext);
            }
            catch (CICSSystemManagerException e) {
                DEBUG.event("getApplicationsForPlatform", (Object)e);
                if (e.getCause() == null || !(e.getCause() instanceof SystemManagerConnectionException)) break block2;
                throw (SystemManagerConnectionException)e.getCause();
            }
        }
        DEBUG.exit("getApplicationsForPlatform", (Object)results);
        return results;
    }

    private ICICSObject[] getApplicationDefinitionsForPlatform(FilteredContext filteredContext) throws SystemManagerConnectionException {
        ICICSObject[] results;
        block2: {
            DEBUG.enter("getApplicationDefinitionsForPlatform", (Object)this, (Object)filteredContext);
            results = new ICICSObject[]{};
            try {
                results = this.getCICSObjects((ICICSType<?>)ApplicationDefinitionType.getInstance(), (IContext)filteredContext);
            }
            catch (CICSSystemManagerException e) {
                DEBUG.event("getApplicationDefinitionsForPlatform", (Object)e);
                if (e.getCause() == null || !(e.getCause() instanceof SystemManagerConnectionException)) break block2;
                throw (SystemManagerConnectionException)e.getCause();
            }
        }
        DEBUG.exit("getApplicationDefinitionsForPlatform", (Object)results);
        return results;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    private boolean isDefinitionForApplication(IApplicationDefinition definition, IApplication application) {
        return definition.getName().equals(application.getApplicationDefinitionName()) && definition.getApplicationDirectory().equals(application.getApplicationDirectory()) && definition.getMajorVersion().equals(application.getMajorVersion()) && definition.getMinorVersion().equals(application.getMinorVersion()) && definition.getMicroVersion().equals(application.getMicroVersion()) && definition.getPlatformDefinition().equals(application.getPlatformDefinitionName());
    }

    @Override
    public String getPlatformDefinitionName() {
        return this.platform.getPlatformDefinitionName();
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_applications, null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformAppsNodeDeferredWorkbenchAdapter other = (PlatformAppsNodeDeferredWorkbenchAdapter)obj;
        return !(this.platform == null ? other.platform != null : !EqualityHelper.equals((ICICSObject)this.platform, (ICICSObject)other.platform));
    }
}

