/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.IDisposableSelectionProvider;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

class PlatformSelectionProvider
implements IDisposableSelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ISelectionService selectionService;
    private final List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private final ISelectionListener selectionListener;
    private final IWorkbenchPart myPart;
    private ISelection selection;
    private ConnectionServiceListener connectionServiceListener;

    public PlatformSelectionProvider(IWorkbenchPart part, Class<? extends IContext> contextType, ISelectionService selectionService, IConnectionService connectionService) {
        this.myPart = part;
        this.selectionService = selectionService;
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection instanceof IStructuredSelection && this.notMy(part)) {
                    PlatformSelectionProvider.this.notifySelectionChanged(selection);
                }
            }

            private boolean notMy(IWorkbenchPart part) {
                return part != PlatformSelectionProvider.this.myPart;
            }
        };
        this.connectionServiceListener = new PlatformSelectionConnectionServiceListener(this);
        connectionService.addConnectionServiceListener(this.connectionServiceListener);
        selectionService.addSelectionListener(this.selectionListener);
        Object selection = UIPlugin.getDefault().getSelectedObject(contextType);
        if (selection != null) {
            this.notifySelectionChanged((ISelection)new StructuredSelection(selection));
        }
    }

    private synchronized void notifySelectionChanged(ISelection selection) {
        this.selection = selection;
        for (ISelectionChangedListener listener : this.listeners) {
            if (selection != null) {
                listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                continue;
            }
            listener.selectionChanged(null);
        }
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void dispose() {
        this.selectionService.removeSelectionListener(this.selectionListener);
        this.connectionServiceListener.makeStale();
        this.listeners.clear();
    }

    private static class PlatformSelectionConnectionServiceListener
    extends ConnectionServiceListener {
        private PlatformSelectionProvider platformSelectionProvider;

        public PlatformSelectionConnectionServiceListener(PlatformSelectionProvider platformSelectionProvider) {
            this.platformSelectionProvider = platformSelectionProvider;
        }

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event.getConnectionCategoryId().equals("com.ibm.cics.sm.connection") && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                this.platformSelectionProvider.notifySelectionChanged(null);
            }
        }

        public synchronized void makeStale() {
            this.platformSelectionProvider = null;
            super.makeStale();
        }
    }
}

