/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.model.IDescribable;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.cics.model.ICICSObject;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public abstract class ResourcesTreeView
extends ViewPart {
    protected TreeViewer viewer;
    private IPartListener2 partListener;
    private ISelectionListener selectionListener;
    private IAction refreshAction;
    private static final Logger logger = Logger.getLogger(UIPlugin.class.getPackage().getName());
    private IHandler commandHandler;

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"createPartControl", (Object)((Object)this), (Object)parent);
        this.setContentDescription(Messages.getString("ResourcesView.status.disconnected", new Object[0]));
        this.viewer = new TreeViewer(parent, 768);
        this.viewer.setContentProvider((IContentProvider)new ExplorerDeferredTreeContentProvider(this.viewer, this.getSite()));
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        ILabelDecorator labelDecorator = decoratorManager.getLabelDecorator();
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"createPartControl", (Object)("labelDecorator=" + labelDecorator));
        }
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"createPartControl", (Object)("com.ibm.cics.core.ui.decorators.cicsPlex=" + decoratorManager.getEnabled("com.ibm.cics.core.ui.decorators.cicsPlex")));
        }
        if (Debug.DEBUG_DECORATORS) {
            Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"createPartControl", (Object)("com.ibm.cics.ad.ui.decorators.managedRegion=" + decoratorManager.getEnabled("com.ibm.cics.ad.ui.decorators.managedRegion")));
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)new ExplorerLabelProvider()), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof ICICSObject) {
                    final ICICSObject aCICSObject = (ICICSObject)selection.getFirstElement();
                    BusyIndicator.showWhile((Display)event.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            UIPlugin.performDefaultViewAction(aCICSObject);
                        }
                    });
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.addListeners();
        MenuManager menuMgr = new MenuManager();
        Menu popupMenu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add((IContributionItem)new Separator("open"));
        this.viewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourcesTreeView.this.viewer.getTree().getAccessible().setFocus(-1);
                ResourcesTreeView.this.viewer.getTree().getAccessible().selectionChanged();
            }
        });
        this.viewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Object selected = ((StructuredSelection)ResourcesTreeView.this.viewer.getSelection()).getFirstElement();
                ResourcesTreeView.this.accessibilitySelectionHandling(e, selected);
            }
        });
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.refresh", this.commandHandler);
        Debug.exit((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"createPartControl");
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"dispose", (Object)((Object)this));
        this.removeListeners();
        super.dispose();
        Debug.exit((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"dispose");
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.refreshAction = new Action(Messages.getString("ResourcesTreeView.refreshAction.name", new Object[0])){

            public void run() {
                ResourcesTreeView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("ResourcesTreeView.refreshAction.tooltip", new Object[0]));
        this.refreshAction.setImageDescriptor(UIPlugin.IMGD_REFRESH);
        this.commandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                ResourcesTreeView.this.refresh();
                return null;
            }
        };
    }

    protected void fillActionBar(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new Separator("refresh"));
        toolBar.appendToGroup("refresh", this.refreshAction);
        toolBar.add((IContributionItem)new Separator("additions"));
    }

    private void addListeners() {
        IWorkbenchWindow workbenchWindow = this.getSite().getPage().getWorkbenchWindow();
        this.partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == ResourcesTreeView.this) {
                    Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"partDeactivated", (Object)this, (Object)partRef.getPartName());
                    ResourcesTreeView.this.clearStatusMessage();
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"addListeners", (Object)((Object)this), (Object)this.partListener);
        workbenchWindow.getPartService().addPartListener(this.partListener);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object firstElement = structuredSelection.getFirstElement();
                    Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"selectionChanged", (Object)firstElement);
                    if (firstElement instanceof IDescribable) {
                        ResourcesTreeView.this.showStatusMessage(((IDescribable)firstElement).getDescription());
                    } else {
                        ResourcesTreeView.this.showStatusMessage("");
                    }
                }
            }
        };
        Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"addListeners", (Object)((Object)this), (Object)this.selectionListener);
        workbenchWindow.getSelectionService().addSelectionListener(this.selectionListener);
    }

    private void removeListeners() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Debug.event((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"removeListeners", (Object[])new Object[]{this, workbenchWindow, this.partListener, this.selectionListener});
        if (workbenchWindow != null) {
            workbenchWindow.getPartService().removePartListener(this.partListener);
            workbenchWindow.getSelectionService().removeSelectionListener(this.selectionListener);
        }
    }

    protected void clearStatusMessage() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(null);
        actionBars.getStatusLineManager().setErrorMessage(null);
        actionBars.updateActionBars();
    }

    protected void showStatusMessage(String message) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(message);
        actionBars.updateActionBars();
    }

    protected void refresh() {
        Debug.enter((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"refresh", (Object)((Object)this));
        this.viewer.refresh(true);
        Debug.exit((Logger)logger, (String)ResourcesTreeView.class.getName(), (String)"refresh");
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        return null;
    }

    protected void accessibilitySelectionHandling(AccessibleEvent e, Object selected) {
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.sm.connection";
        }
        return super.getPartProperty(key);
    }

    protected class ExplorerDeferredTreeContentProvider
    implements ITreeContentProvider {
        static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        private DeferredTreeContentManager manager;

        public ExplorerDeferredTreeContentProvider(TreeViewer viewer, IWorkbenchPartSite site) {
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer, site){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    IDeferredWorkbenchAdapter adapter = ResourcesTreeView.this.getAdapter(element);
                    if (adapter == null) {
                        adapter = super.getAdapter(element);
                    }
                    Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getAdapter", (Object)element, (Object)adapter);
                    return adapter;
                }
            };
        }

        public Object[] getChildren(Object parentElement) {
            return this.manager.getChildren(parentElement);
        }

        public DeferredTreeContentManager getManager() {
            return this.manager;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.manager.mayHaveChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.manager.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.manager.cancel(oldInput);
            }
        }
    }

    protected class ExplorerLabelProvider
    extends CellLabelProvider
    implements ILabelProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        protected ExplorerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return Messages.getString("pending", new Object[0]);
            }
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return UIPlugin.getImage(UIPlugin.IMGD_WAITING);
            }
            Image image = null;
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                image = UIPlugin.getImage(adapter.getImageDescriptor(element));
            }
            return image;
        }

        private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
            String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
            IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
            return adapter;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IDescribable) {
                return ((IDescribable)element).getDescription();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 10);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }

        public StyledString getStyledText(Object element) {
            StyledString result = new StyledString(this.getText(element));
            return result;
        }
    }
}

