/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.cpsm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CPSMRecordCompensations {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger;
    private static final Map<String, Set<String>> COMPENSATION_MAP;
    private static final String PROPERTIES_FILENAME = "CPSMRecordCompensations.properties";

    static {
        Properties props;
        block16: {
            logger = Logger.getLogger("com.ibm.cics.sm.comm.cpsm");
            COMPENSATION_MAP = new HashMap<String, Set<String>>();
            props = new Properties();
            InputStream istream = CPSMRecordCompensations.class.getResourceAsStream(PROPERTIES_FILENAME);
            if (istream != null) {
                try {
                    try {
                        props.load(istream);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Could not load stream from CPSMRecordCompensations.properties", ex);
                        try {
                            istream.close();
                        }
                        catch (IOException ex2) {
                            logger.log(Level.WARNING, "Could not close stream obtained from CPSMRecordCompensations.properties", ex2);
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        istream.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "Could not close stream obtained from CPSMRecordCompensations.properties", ex);
                    }
                    throw throwable;
                }
                try {
                    istream.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, "Could not close stream obtained from CPSMRecordCompensations.properties", ex);
                }
            } else {
                logger.log(Level.SEVERE, "Could not get stream for CPSMRecordCompensations.properties");
            }
        }
        Enumeration<?> it = props.propertyNames();
        while (it.hasMoreElements()) {
            String resName = (String)it.nextElement();
            String attributesCSLine = props.getProperty(resName);
            String[] attributesAndBlanks = attributesCSLine.split("[,\\s]");
            HashSet<String> attributesSet = new HashSet<String>();
            int i = 0;
            while (i < attributesAndBlanks.length) {
                String attributeOrBlank = attributesAndBlanks[i].trim();
                if (attributeOrBlank.length() > 0) {
                    attributesSet.add(attributeOrBlank);
                }
                ++i;
            }
            COMPENSATION_MAP.put(resName, Collections.unmodifiableSet(attributesSet));
        }
    }

    public static boolean shouldCleanQuotedNumber(String attribute, String resourceName) {
        Set<String> attributesForResource = CPSMRecordCompensations.setForResource(resourceName);
        return attributesForResource != null && attributesForResource.contains(attribute);
    }

    static Set<String> setForResource(String resourceName) {
        Set<String> attributesForResource = COMPENSATION_MAP.get(resourceName);
        return attributesForResource;
    }
}

