/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CredentialsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CredentialsConfiguration credentialsConfiguration;
    private ICredentialsManager credentialsManager;
    private TitleAreaDialogErrorStateManager errorStateManager;
    private PasswordComposite passwordComposite;
    private boolean isEditMode;
    private String initialCredentialsNameForCreate;
    private String initialUserNameForCreate;

    public CredentialsDialog(Shell parentShell, boolean isEditMode) {
        super(parentShell);
        this.isEditMode = isEditMode;
        this.credentialsManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
        this.errorStateManager = new TitleAreaDialogErrorStateManager((TitleAreaDialog)this);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ConnectionsImages.getImage("PASSWORD_WIZ_BAN"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.logindetails_dialog");
        this.getShell().setText(Messages.LoginDetailsDialog_msg);
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        this.passwordComposite = new PasswordComposite(childArea, 0, true, this.credentialsManager.isPasswordSaveable(), CredentialsMode.EDIT_CREDENTIAL, this.credentialsManager);
        if (this.isEditMode) {
            this.passwordComposite.setCredentialsName(this.credentialsConfiguration.getName());
            this.passwordComposite.setUserID(this.credentialsConfiguration.getUserID());
            if (StringUtil.hasContent((String)this.credentialsConfiguration.getPassword())) {
                this.passwordComposite.setPassword(this.credentialsConfiguration.getPassword());
            }
            this.passwordComposite.setSavePassword(this.credentialsConfiguration.isSavePassword());
        } else {
            if (StringUtil.hasContent((String)this.initialCredentialsNameForCreate)) {
                this.passwordComposite.setUserID(this.initialUserNameForCreate);
            }
            if (StringUtil.hasContent((String)this.initialUserNameForCreate)) {
                this.passwordComposite.setCredentialsName(this.initialUserNameForCreate);
            }
        }
        data = new GridData(4, 4, true, true);
        this.passwordComposite.setLayoutData(data);
        this.createTitle();
        this.setMessage(Messages.CredentialsDialog_specfy_host_msg);
        this.setInitialFocus();
        this.passwordComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CredentialsDialog.this.validateData();
            }
        });
        return c;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.validateData();
        return c;
    }

    private void validateData() {
        boolean error = false;
        this.errorStateManager.clearErrors();
        this.setMessage(Messages.CredentialsDialog_specfy_host_msg);
        if (StringUtil.isEmpty((String)this.passwordComposite.getCredentialsName())) {
            this.errorStateManager.recordSevereError(Messages.CredentialsPreferencePage_invalidName, (Control)this.passwordComposite.credentialsText);
            error = true;
        } else if (this.isDuplicateInList(this.passwordComposite.getCredentialsName())) {
            this.errorStateManager.recordSevereError(Messages.CredentialsPreferencePage_duplicateName, (Control)this.passwordComposite.credentialsText);
            error = true;
        } else if (StringUtil.isEmpty((String)this.passwordComposite.getUserID())) {
            this.setErrorMessage(Messages.CredentialsDialog_mandatoryUserID);
            error = true;
        }
        this.getButton(0).setEnabled(!error);
    }

    private boolean isDuplicateInList(String newName) {
        for (CredentialsConfiguration credential : this.credentialsManager.getAllCredentials()) {
            if (!newName.equals(credential.getName())) continue;
            if (this.isEditMode) {
                if (this.credentialsConfiguration.getID().equals(credential.getID())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private void setInitialFocus() {
        if (this.isEditMode) {
            if (StringUtil.hasContent((String)this.credentialsConfiguration.getPassword())) {
                this.passwordComposite.passwordText.setFocus();
                this.passwordComposite.passwordText.selectAll();
            } else {
                this.passwordComposite.userIDText.setFocus();
                this.passwordComposite.userIDText.selectAll();
            }
        } else {
            this.passwordComposite.userIDText.setFocus();
            this.passwordComposite.userIDText.selectAll();
        }
    }

    private void createTitle() {
        if (this.isEditMode) {
            this.setTitle(Messages.ConnectionDialog_Edit_Credential);
            this.getShell().setText(Messages.ConnectionDialog_Edit_Credential);
        } else {
            this.setTitle(Messages.CredentialsManager_newCredentials);
            this.getShell().setText(Messages.CredentialsManager_newCredentials);
        }
    }

    protected void okPressed() {
        if (this.isEditMode) {
            this.credentialsConfiguration.setUserID(this.passwordComposite.getUserID());
            this.credentialsConfiguration.setPassword(this.passwordComposite.getPassword());
            this.credentialsConfiguration.setName(this.passwordComposite.getCredentialsName());
            this.credentialsConfiguration.setSavePassword(this.passwordComposite.isSavePassword());
            this.credentialsManager.update(this.credentialsConfiguration);
        } else {
            CredentialsConfiguration newCredentialsConfiguration = new CredentialsConfiguration(IDFactory.createNewId(), this.passwordComposite.getCredentialsName(), this.passwordComposite.getUserID(), this.passwordComposite.getPassword(), this.passwordComposite.isSavePassword());
            this.credentialsManager.update(newCredentialsConfiguration);
        }
        super.okPressed();
    }

    public void setCredentialsConfiguration(CredentialsConfiguration credentialsConfiguration) {
        this.credentialsConfiguration = credentialsConfiguration;
    }

    public void setInitialCreateDetails(String userName, String newCredentialsName) {
        this.initialUserNameForCreate = userName;
        this.initialCredentialsNameForCreate = newCredentialsName;
    }
}

