/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PasswordComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    @Deprecated
    public Text passwordText;
    @Deprecated
    public Button savePasswordButton;
    @Deprecated
    public Text userIDText;
    private Label passwordSaveWarningLabel;
    Text credentialsText;
    private boolean credentialsIsDefaultValue = true;
    private String hostName;
    private CredentialsMode credentialsMode;
    private boolean showSavePassword;
    private boolean passwordSaveable;
    Combo credentialsCombo;
    private CredentialsConfiguration credentialsConfiguration;
    private List<CredentialsConfiguration> allCredentials = new ArrayList<CredentialsConfiguration>();
    Button createNewCredentialButton;
    Button useExistingCredentialButton;
    private String connectionDescription;
    private Label credentialsInfoLabel;
    private String thisIsTheFirstTimeToConnectMsg;
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>(1);
    Text newPasswordOrPassPhrase;
    Text confirmNewPasswordOrPassPhrase;
    private final ICredentialsManager credentialsManager;

    public PasswordComposite(Composite parent, int style, boolean showUserID, boolean cantSavePassword, CredentialsMode mode, ICredentialsManager credentialsManager) {
        this(parent, style, showUserID, cantSavePassword, true, mode, credentialsManager);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.passwordText != null) {
            this.passwordText.setEnabled(enabled);
        }
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setEnabled(enabled);
        }
        this.userIDText.setEnabled(enabled);
    }

    public PasswordComposite(Composite parent, int style, boolean showUserID, boolean aPasswordSaveable, boolean aShowSavePassword, CredentialsMode mode, ICredentialsManager credentialsManager) {
        super(parent, style);
        this.credentialsMode = mode;
        this.showSavePassword = aShowSavePassword;
        this.passwordSaveable = aPasswordSaveable;
        this.credentialsManager = credentialsManager;
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        if (mode == CredentialsMode.CREATE_FIRST_CREDENTIAL) {
            this.createUserInterfaceForFirstCredential();
            this.createUserInterfaceForCredentialsName();
        } else if (mode == CredentialsMode.CREATE_CREDENTIAL) {
            this.createUserInterfaceForNoCredential();
            this.createUserInterfaceForCredentialsName();
        } else if (mode == CredentialsMode.EDIT_CREDENTIAL) {
            this.createUserInterfaceForCredentialsName();
        } else if (mode == CredentialsMode.CHANGE_PASSWORD) {
            this.createUserInterfaceForCredentialsName();
        }
        this.createUserIDandPasswordUserInterface();
        if (mode == CredentialsMode.CREATE_CREDENTIAL) {
            this.useExistingCredentialButton.setSelection(true);
            this.userIDText.setEnabled(false);
            this.passwordText.setEnabled(false);
            this.savePasswordButton.setEnabled(false);
            this.credentialsText.setEnabled(false);
            this.credentialsCombo.setEnabled(true);
            if (this.credentialsCombo.getSelectionIndex() == -1 && this.credentialsCombo.getItemCount() > 0) {
                this.credentialsCombo.select(0);
                this.credentialsConfiguration = this.allCredentials.get(0);
            }
        }
    }

    private void createUserIDandPasswordUserInterface() {
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordComposite_userId);
        this.userIDText = new Text((Composite)this, 2048);
        TextInput.setAccessibleLabel((Text)this.userIDText, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        this.userIDText.setLayoutData((Object)data);
        if (this.showSavePassword) {
            Label passwordLabel = new Label((Composite)this, 0);
            if (this.credentialsMode == CredentialsMode.CHANGE_PASSWORD) {
                passwordLabel.setText(Messages.PasswordComposite_existing_password);
            } else {
                passwordLabel.setText(Messages.PasswordComposite_password);
            }
            this.passwordText = new Text((Composite)this, 0x400800);
            TextInput.setAccessibleLabel((Text)this.passwordText, (Label)passwordLabel);
            data = new GridData(4, 0x1000000, true, false);
            data.horizontalIndent = 20;
            this.passwordText.setLayoutData((Object)data);
            if (this.credentialsMode == CredentialsMode.CHANGE_PASSWORD) {
                this.createUserInterfaceForNewPassword();
            }
            Composite passwordWarningComposite = new Composite((Composite)this, 0);
            data = new GridData(4, 0, true, false);
            data.horizontalSpan = 2;
            passwordWarningComposite.setLayoutData((Object)data);
            passwordWarningComposite.setLayout((Layout)new GridLayout(2, false));
            if (this.credentialsMode != CredentialsMode.CHANGE_PASSWORD) {
                this.savePasswordButton = new Button(passwordWarningComposite, 32);
                this.savePasswordButton.setSelection(false);
                this.savePasswordButton.setText(Messages.PasswordComposite_savePassword);
                data = new GridData(4, 0, true, false);
                data.horizontalSpan = 2;
                this.savePasswordButton.setLayoutData((Object)data);
                this.savePasswordButton.setVisible(this.showSavePassword);
                if (!this.passwordSaveable) {
                    this.savePasswordButton.setEnabled(false);
                }
                Label passwordSaveWarningIcon = new Label(passwordWarningComposite, 0);
                passwordSaveWarningIcon.setImage(ConnectionsImages.getImage("WARNING"));
                data = new GridData(0, 0x1000000, false, true);
                passwordSaveWarningIcon.setLayoutData((Object)data);
                this.passwordSaveWarningLabel = new Label(passwordWarningComposite, 64);
                this.passwordSaveWarningLabel.setText(Messages.PasswordComposite_savePasswordDescription);
                data = new GridData(4, 0x1000000, true, false);
                data.widthHint = 350;
                this.passwordSaveWarningLabel.setLayoutData((Object)data);
            }
        }
        this.addListeners();
    }

    private void createUserInterfaceForNoCredential() {
        this.credentialsInfoLabel = new Label((Composite)this, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.widthHint = 350;
        this.credentialsInfoLabel.setLayoutData((Object)data);
        this.thisIsTheFirstTimeToConnectMsg = Messages.PasswordComposite_NoCrededneitials_Info;
        this.credentialsInfoLabel.setText(this.thisIsTheFirstTimeToConnectMsg);
        this.useExistingCredentialButton = new Button((Composite)this, 16);
        this.useExistingCredentialButton.setText(Messages.PasswordComposite_UseExistingCredentialsInfo);
        this.useExistingCredentialButton.setLayoutData((Object)data);
        data = new GridData(4, 0, true, false);
        data.verticalIndent = 5;
        data.horizontalSpan = 3;
        this.useExistingCredentialButton.setLayoutData((Object)data);
        Label credentialsLabel = new Label((Composite)this, 0);
        credentialsLabel.setText(Messages.PasswordComposite_credentialsLabel);
        data = new GridData(0, 0, false, false);
        data.horizontalIndent = 5;
        credentialsLabel.setLayoutData((Object)data);
        this.credentialsCombo = new Combo((Composite)this, 2056);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 15;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.credentialsCombo.setLayoutData((Object)data);
        this.allCredentials.addAll(this.credentialsManager.getAllCredentials());
        for (CredentialsConfiguration credentialsConfiguration : this.allCredentials) {
            this.credentialsCombo.add(credentialsConfiguration.getName());
        }
        this.createNewCredentialButton = new Button((Composite)this, 16);
        this.createNewCredentialButton.setText(Messages.PasswordComposite_CreateLoginDetailsInfo);
        this.createNewCredentialButton.setLayoutData((Object)data);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        this.createNewCredentialButton.setLayoutData((Object)data);
        this.credentialsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordComposite.this.credentialsConfiguration = (CredentialsConfiguration)PasswordComposite.this.allCredentials.get(PasswordComposite.this.credentialsCombo.getSelectionIndex());
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean canEnterNewCredentialsDetails = PasswordComposite.this.createNewCredentialButton.getSelection();
                PasswordComposite.this.userIDText.setEnabled(canEnterNewCredentialsDetails);
                PasswordComposite.this.passwordText.setEnabled(canEnterNewCredentialsDetails);
                PasswordComposite.this.credentialsText.setEnabled(canEnterNewCredentialsDetails);
                PasswordComposite.this.savePasswordButton.setEnabled(canEnterNewCredentialsDetails);
                PasswordComposite.this.credentialsCombo.setEnabled(PasswordComposite.this.useExistingCredentialButton.getSelection());
                if (PasswordComposite.this.createNewCredentialButton.getSelection()) {
                    PasswordComposite.this.userIDText.setFocus();
                }
                for (ModifyListener modifyListenber : PasswordComposite.this.modifyListeners) {
                    modifyListenber.modifyText(null);
                }
            }
        };
        this.createNewCredentialButton.addSelectionListener((SelectionListener)radioListener);
        this.useExistingCredentialButton.addSelectionListener((SelectionListener)radioListener);
        this.useExistingCredentialButton.setSelection(true);
    }

    private void createUserInterfaceForFirstCredential() {
        Label credentialsInfoLabel = new Label((Composite)this, 64);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 3;
        data.widthHint = 350;
        credentialsInfoLabel.setLayoutData((Object)data);
        StringBuffer buffer = new StringBuffer();
        buffer.append(Messages.PasswordComposite_MustAssignOrCreateForConfigurationWithNoCredentials);
        buffer.append(" ");
        buffer.append(Messages.PasswordComposite_NameHelpsToIdentifyInfo);
        credentialsInfoLabel.setText(buffer.toString());
    }

    private void createUserInterfaceForCredentialsName() {
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordComposite_credentialsLabel);
        this.credentialsText = new Text((Composite)this, 2048);
        TextInput.setAccessibleLabel((Text)this.credentialsText, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 100;
        data.verticalIndent = 5;
        this.credentialsText.setLayoutData((Object)data);
    }

    private void createUserInterfaceForNewPassword() {
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordDialog_New_Password);
        this.newPasswordOrPassPhrase = new Text((Composite)this, 0x400800);
        TextInput.setAccessibleLabel((Text)this.newPasswordOrPassPhrase, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.newPasswordOrPassPhrase.setLayoutData((Object)data);
        l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordDialog_New_Password_confirm);
        this.confirmNewPasswordOrPassPhrase = new Text((Composite)this, 0x400800);
        TextInput.setAccessibleLabel((Text)this.confirmNewPasswordOrPassPhrase, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.confirmNewPasswordOrPassPhrase.setLayoutData((Object)data);
    }

    private void addListeners() {
        if (this.credentialsText != null) {
            this.userIDText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (PasswordComposite.this.credentialsIsDefaultValue) {
                        PasswordComposite.this.credentialsText.setText(ConnectionUtils.generateName(PasswordComposite.this.hostName, PasswordComposite.this.userIDText.getText()));
                    }
                }
            });
            this.credentialsText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String generatedName;
                    if (PasswordComposite.this.credentialsIsDefaultValue && !(generatedName = ConnectionUtils.generateName(PasswordComposite.this.hostName, PasswordComposite.this.userIDText.getText())).toLowerCase().equals(PasswordComposite.this.credentialsText.getText().toLowerCase())) {
                        PasswordComposite.this.credentialsIsDefaultValue = false;
                    }
                }
            });
        }
        ModifyListener controlModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (ModifyListener modifyListener : PasswordComposite.this.modifyListeners) {
                    modifyListener.modifyText(e);
                }
            }
        };
        this.passwordText.addModifyListener(controlModifyListener);
        this.userIDText.addModifyListener(controlModifyListener);
        if (this.credentialsText != null) {
            this.credentialsText.addModifyListener(controlModifyListener);
        }
        if (this.newPasswordOrPassPhrase != null) {
            this.newPasswordOrPassPhrase.addModifyListener(controlModifyListener);
        }
        if (this.confirmNewPasswordOrPassPhrase != null) {
            this.confirmNewPasswordOrPassPhrase.addModifyListener(controlModifyListener);
        }
    }

    public void setSavePassword(boolean savePassword) {
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setSelection(savePassword);
        }
    }

    public boolean isSavePassword() {
        return this.savePasswordButton != null ? this.savePasswordButton.getSelection() : false;
    }

    public void setCredentialsName(String credentialsName) {
        if (this.credentialsText != null) {
            this.credentialsText.setText(credentialsName);
        }
    }

    public void setUserID(String userID) {
        this.userIDText.setText(userID);
    }

    public void setEditable(boolean aBoolean) {
        this.userIDText.setEditable(aBoolean);
        if (this.savePasswordButton != null) {
            this.savePasswordButton.setEnabled(aBoolean);
        }
        if (this.passwordText != null) {
            this.passwordText.setEditable(aBoolean);
        }
    }

    public void setPassword(String password) {
        if (this.passwordText != null && this.passwordText.isEnabled()) {
            this.passwordText.setText(password);
        }
    }

    public String getPassword() {
        if (this.passwordText != null && this.passwordText.isEnabled()) {
            return this.passwordText.getText();
        }
        return "";
    }

    public String getNewPassword() {
        if (this.newPasswordOrPassPhrase != null && this.newPasswordOrPassPhrase.isEnabled()) {
            return this.newPasswordOrPassPhrase.getText();
        }
        return "";
    }

    public String getUserID() {
        return this.userIDText.getText().trim();
    }

    public void setLongPasswordSaveWarningLabel(boolean useLong) {
        if (this.passwordSaveWarningLabel != null) {
            String warningText = useLong ? Messages.PasswordComposite_savePasswordDescriptionLong : Messages.PasswordComposite_savePasswordDescription;
            this.passwordSaveWarningLabel.setText(warningText);
        }
    }

    public void setCredentials(CredentialsConfiguration credentialsConfiguration) {
        if (credentialsConfiguration == null) {
            return;
        }
        this.credentialsConfiguration = credentialsConfiguration;
        if (this.credentialsMode == CredentialsMode.CREATE_CREDENTIAL) {
            this.credentialsCombo.select(this.allCredentials.indexOf(credentialsConfiguration));
        } else if (this.credentialsMode != CredentialsMode.AUTHENTICATE_CREDENTIAL && this.credentialsMode == CredentialsMode.CREATE_CREDENTIAL && this.credentialsText != null) {
            this.credentialsText.setText(credentialsConfiguration.getName());
        }
    }

    public CredentialsConfiguration getCredentialsConfiguration() {
        return this.credentialsConfiguration;
    }

    public void setCredentialsIsDefaultValue(boolean isDefaultValue) {
        this.credentialsIsDefaultValue = isDefaultValue;
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public void setConnectionDescription(String aConnectionDescription) {
        this.connectionDescription = aConnectionDescription;
        if (this.credentialsInfoLabel != null) {
            String credentialsInfoLblMessage = MessageFormat.format(this.thisIsTheFirstTimeToConnectMsg, this.connectionDescription);
            this.credentialsInfoLabel.setText(credentialsInfoLblMessage);
        }
    }

    public boolean shouldCreateNewCredentials() {
        return this.createNewCredentialButton == null ? false : this.createNewCredentialButton.getSelection();
    }

    public String getCredentialsName() {
        return this.credentialsText.getText();
    }

    public void addModifyListener(ModifyListener aModifyListener) {
        this.modifyListeners.add(aModifyListener);
    }
}

