/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.Debug;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LabelUtil {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BUNDLE_NAME = "com.ibm.cics.common.util.messages";
    private static final Object[] EMPTY_INSERTS = new Object[0];
    private static final Debug debug = new Debug(LabelUtil.class);
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.cics.common.util.messages");

    public static String appendColon(String label) {
        return LabelUtil.getString("LabelUtil.withColon", label);
    }

    public static String getString(String key) {
        return LabelUtil.getString(key, EMPTY_INSERTS);
    }

    public static String getString(String key, Object insert0) {
        return LabelUtil.getString(key, new Object[]{insert0});
    }

    public static String getString(String key, Object insert0, Object insert1) {
        return LabelUtil.getString(key, new Object[]{insert0, insert1});
    }

    public static String getString(String key, Object insert0, Object insert1, Object insert2) {
        return LabelUtil.getString(key, new Object[]{insert0, insert1, insert2});
    }

    public static String getString(String key, Object[] inserts) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), inserts);
        }
        catch (MissingResourceException missingResourceException) {
            debug.warning("getString", (Object)"Missing property from resource bundle \"com.ibm.cics.common.util.messages\"", key);
            return String.valueOf('!') + key + '!';
        }
    }
}

