/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.GlobalUserExitReference;
import com.ibm.cics.core.model.GlobalUserExitType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.IGlobalUserExit;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class GlobalUserExit
extends CICSResource
implements IGlobalUserExit {
    private String _program;
    private String _exitpoint;
    private String _entryname;
    private String _gaentryname;
    private IGlobalUserExit.StartStatusValue _startstatus;
    private Long _gausecount;
    private Long _galength;
    private Long _numexits;
    private String _entry;

    public GlobalUserExit(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("PROGRAM");
        this._program = (String)((CICSAttribute)GlobalUserExitType.PROGRAM_NAME).get(stringValue, normalizers);
        stringValue = record.get("EXITPOINT");
        this._exitpoint = (String)((CICSAttribute)GlobalUserExitType.EXIT_POINT).get(stringValue, normalizers);
        stringValue = record.get("ENTRYNAME");
        this._entryname = (String)((CICSAttribute)GlobalUserExitType.ENTRY_NAME).get(stringValue, normalizers);
        stringValue = record.get("GAENTRYNAME");
        this._gaentryname = (String)((CICSAttribute)GlobalUserExitType.GA_ENTRY_NAME).get(stringValue, normalizers);
        stringValue = record.get("STARTSTATUS");
        this._startstatus = (IGlobalUserExit.StartStatusValue)((CICSAttribute)GlobalUserExitType.START_STATUS).get(stringValue, normalizers);
        stringValue = record.get("GAUSECOUNT");
        this._gausecount = (Long)((CICSAttribute)GlobalUserExitType.GA_USER_COUNT).get(stringValue, normalizers);
        stringValue = record.get("GALENGTH");
        this._galength = (Long)((CICSAttribute)GlobalUserExitType.GA_LENGTH).get(stringValue, normalizers);
        stringValue = record.get("NUMEXITS");
        this._numexits = (Long)((CICSAttribute)GlobalUserExitType.NUMBER_OF_ENABLED_EXITS).get(stringValue, normalizers);
        stringValue = record.get("ENTRY");
        this._entry = (String)((CICSAttribute)GlobalUserExitType.ENTRY_ADDRESS).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return GlobalUserExitType.PROGRAM_NAME.internalToExternal((Object)this.getProgramName());
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            return "";
        }
    }

    public String getProgramName() {
        return this._program;
    }

    public String getExitPoint() {
        return this._exitpoint;
    }

    public String getEntryName() {
        return this._entryname;
    }

    public String getGAEntryName() {
        return this._gaentryname;
    }

    public IGlobalUserExit.StartStatusValue getStartStatus() {
        return this._startstatus;
    }

    public Long getGAUserCount() {
        return this._gausecount;
    }

    public Long getGALength() {
        return this._galength;
    }

    public Long getNumberOfEnabledExits() {
        return this._numexits;
    }

    public String getEntryAddress() {
        return this._entry;
    }

    public GlobalUserExitType getObjectType() {
        return GlobalUserExitType.getInstance();
    }

    @Override
    public GlobalUserExitReference getCICSObjectReference() {
        return new GlobalUserExitReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == GlobalUserExitType.PROGRAM_NAME) {
            return (V)this.getProgramName();
        }
        if (attribute == GlobalUserExitType.EXIT_POINT) {
            return (V)this.getExitPoint();
        }
        if (attribute == GlobalUserExitType.ENTRY_NAME) {
            return (V)this.getEntryName();
        }
        if (attribute == GlobalUserExitType.GA_ENTRY_NAME) {
            return (V)this.getGAEntryName();
        }
        if (attribute == GlobalUserExitType.START_STATUS) {
            return (V)this.getStartStatus();
        }
        if (attribute == GlobalUserExitType.GA_USER_COUNT) {
            return (V)this.getGAUserCount();
        }
        if (attribute == GlobalUserExitType.GA_LENGTH) {
            return (V)this.getGALength();
        }
        if (attribute == GlobalUserExitType.NUMBER_OF_ENABLED_EXITS) {
            return (V)this.getNumberOfEnabledExits();
        }
        if (attribute == GlobalUserExitType.ENTRY_ADDRESS) {
            return (V)this.getEntryAddress();
        }
        V value = super.getAttributeValue(attribute);
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException("Supplied attribute \"" + attribute + "\" was not a valid attribute for type " + GlobalUserExitType.getInstance());
    }
}

