/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IComplexFilterExpression;
import com.ibm.cics.sm.comm.IComplexFilterVisitor;
import com.ibm.cics.sm.comm.InvalidFilterException;

public class FilterData<E>
implements IComplexFilterExpression {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final E field;
    private final FilterOperator operator;
    private final String string;

    public FilterData(E field, FilterOperator operator, String string) {
        this.field = field;
        this.operator = operator;
        this.string = string;
    }

    public E getFilterField() {
        return this.field;
    }

    public FilterOperator getFilterOperator() {
        return this.operator;
    }

    public String getFilterString() {
        return this.string;
    }

    public String toString() {
        return this.getFilterField() + ":" + (Object)((Object)this.getFilterOperator()) + ":" + this.getFilterString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterData other = (FilterData)obj;
        if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }

    public <F> F accept(IComplexFilterVisitor<F> visitor) throws InvalidFilterException {
        return visitor.visit(this);
    }

    public static enum FilterOperator {
        EQUALS,
        SAME,
        NOT_EQUAL,
        LESS_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN,
        GREATER_THAN_EQUAL;

    }
}

