/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.IResourceErrors;
import com.ibm.cics.sm.comm.ISystemManagerReasonValues;
import com.ibm.cics.sm.comm.ISystemManagerResponseValues;
import java.lang.reflect.Field;
import java.net.URL;

public class SystemManagerConnectionException
extends ConnectionException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    private URL url;
    private int responseCode = 200;
    protected int response = 1024;
    protected int reason = 0;
    private String function = "UKNOWN";
    private IResourceErrorCode errorCode;
    private int resp1 = 0;
    private int resp2 = 0;
    private String attribute;
    private String resp1Name;

    public SystemManagerConnectionException(String message) {
        super(message);
    }

    public SystemManagerConnectionException(Exception ex) {
        super(ex);
    }

    public SystemManagerConnectionException(String message, Exception ex) {
        super(message, (Throwable)ex);
    }

    public SystemManagerConnectionException(int responseCode, String responseMessage) {
        super(responseMessage);
        this.responseCode = responseCode;
    }

    public SystemManagerConnectionException(int response, int reason) {
        super(String.valueOf(SystemManagerConnectionException.getResponseName(response)) + ", " + SystemManagerConnectionException.getReasonName(reason));
        this.response = response;
        this.reason = reason;
    }

    public String getResponseName() {
        return SystemManagerConnectionException.getResponseName(this.response);
    }

    private static String getResponseName(int response) {
        return SystemManagerConnectionException.getFieldName(ISystemManagerResponseValues.class, response);
    }

    public String getReasonName() {
        return SystemManagerConnectionException.getReasonName(this.reason);
    }

    private static String getReasonName(int reason) {
        return SystemManagerConnectionException.getFieldName(ISystemManagerReasonValues.class, reason);
    }

    protected static int getReasonCode(String reasonName) throws Exception {
        return SystemManagerConnectionException.getFieldIntValue(ISystemManagerReasonValues.class, reasonName);
    }

    protected static int getResponseCode(String responseName) throws Exception {
        return SystemManagerConnectionException.getFieldIntValue(ISystemManagerResponseValues.class, responseName);
    }

    private static int getFieldIntValue(Class clazz, String fieldName) throws Exception {
        Field field = clazz.getField(fieldName);
        return field.getInt(null);
    }

    static String getFieldName(Class clazz, int response) {
        Field[] fields;
        String name = String.valueOf(response);
        Field[] fieldArray = fields = clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String fieldName = field.getName();
            if ((field.getModifiers() & 8) == 8) {
                try {
                    Integer fieldValue;
                    Object fieldObject = field.get(null);
                    if (fieldObject instanceof Integer && response == (fieldValue = (Integer)fieldObject)) {
                        name = fieldName;
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++n2;
        }
        return name;
    }

    public SystemManagerConnectionException(String message, int response, int reason) {
        super(message);
        this.response = response;
        this.reason = reason;
    }

    public SystemManagerConnectionException(String resourceType, int response, int reason, String eibFunctionName, int resp, String respName, int resp2) {
        super(String.valueOf(resourceType) + ", " + SystemManagerConnectionException.getResponseName(response) + ", " + SystemManagerConnectionException.getReasonName(reason));
        this.response = response;
        this.reason = reason;
        this.function = eibFunctionName;
        this.resp1 = resp;
        this.resp1Name = respName;
        this.resp2 = resp2;
    }

    @Deprecated
    public SystemManagerConnectionException(int response, int reason, String function, int resp1, String resp1Name, int resp2, int errorCode, String attributeName) {
        this("", response, reason, function, resp1, resp1Name, resp2, new IResourceErrors.UnknownError(errorCode), attributeName);
    }

    public SystemManagerConnectionException(String resourceType, int response, int reason, String function, int resp1, String resp1Name, int resp2, IResourceErrorCode errorCode, String attributeName) {
        super(String.valueOf(resourceType) + ", " + SystemManagerConnectionException.getResponseName(response) + ", " + SystemManagerConnectionException.getReasonName(reason));
        this.response = response;
        this.reason = reason;
        this.function = function;
        this.resp1 = resp1;
        this.resp1Name = resp1Name;
        this.resp2 = resp2;
        this.attribute = attributeName;
        this.errorCode = errorCode;
    }

    @Deprecated
    public SystemManagerConnectionException(int response, int reason, int errorCode, String attributeName) {
        this(response, reason, new IResourceErrors.UnknownError(errorCode), attributeName);
    }

    public SystemManagerConnectionException(int response, int reason, IResourceErrorCode errorCode, String attributeName) {
        super(String.valueOf(attributeName) + ", " + errorCode);
        this.response = response;
        this.reason = reason;
        this.errorCode = errorCode;
        this.attribute = attributeName;
    }

    public SystemManagerConnectionException(URL url, int responseCode, String responseMessage) {
        super(responseMessage);
        this.url = url;
        this.responseCode = responseCode;
    }

    public SystemManagerConnectionException(String message, URL url, int responseCode, String responseMessage) {
        super(message);
        this.url = url;
        this.responseCode = responseCode;
    }

    public URL getURL() {
        return this.url;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getResponse() {
        return this.response;
    }

    public int getReason() {
        return this.reason;
    }

    public String getFunction() {
        return this.function;
    }

    @Deprecated
    public int getErrorCode() {
        return this.errorCode.getErrorCode();
    }

    public IResourceErrorCode getFeedbackErrorCode() {
        return this.errorCode;
    }

    public int getResp1() {
        return this.resp1;
    }

    public String getResp1Name() {
        return this.resp1Name;
    }

    public int getResp2() {
        return this.resp2;
    }

    public String getAttribute() {
        return this.attribute;
    }
}

