/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.ConnectionParametersExporter;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.WritableConnectionProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class ConnectionParameterImporter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final WritableConnectionProvider localConnectionProvider;
    private final ConnectionRegistry registry;

    public ConnectionParameterImporter(ConnectionRegistry registry, WritableConnectionProvider localConnectionProvider) {
        this.registry = registry;
        this.localConnectionProvider = localConnectionProvider;
    }

    public void importConnections(IConnectionDeserializer deser, boolean keepDuplicates) throws IOException {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        ArrayList<ConnectionParameters> newParametersList = new ArrayList<ConnectionParameters>();
        for (ConnectionParameters parameters : deser.load()) {
            ConnectionParameters newParameters = this.createNewParameters(parameters, keepDuplicates);
            if (newParameters == null) continue;
            idsMap.put(parameters.getId(), newParameters.getId());
            newParametersList.add(newParameters);
        }
        for (ConnectionParameters newParameters : newParametersList) {
            newParameters = ConnectionParametersExporter.updateReferences(newParameters, this.registry, idsMap);
            this.localConnectionProvider.updateConnectionParameters(newParameters);
        }
    }

    private ConnectionParameters createNewParameters(ConnectionParameters oldParameters, boolean keepDuplicates) {
        ConnectionParameters newParameters;
        try {
            newParameters = this.localConnectionProvider.createConnectionParameters(this.getInternalId(oldParameters.getId()), oldParameters.getName(), oldParameters.getConnectionTypeId(), oldParameters.getAttributes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            newParameters = keepDuplicates ? this.localConnectionProvider.createConnectionParameters(oldParameters.getName(), oldParameters.getConnectionTypeId(), oldParameters.getAttributes()) : null;
        }
        return newParameters;
    }

    private String getInternalId(String id) {
        return ConnectionUtils.isInternalId(id) ? id : ConnectionUtils.getInternalId(id);
    }
}

