/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConnectionsXMLSerializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionsXMLSerializer.class);
    private static final String CONN = "connections";
    private static final String TYPE = "type";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "configID";
    private static final Set<String> mandatoryAttributes;
    private static final XPathExpression typesExpression;
    private static final XPathExpression configsExpression;

    static {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            typesExpression = xPath.compile("/connections/type");
            configsExpression = xPath.compile(ATTR_ID);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        mandatoryAttributes = new HashSet<String>();
        mandatoryAttributes.add(ATTR_ID);
        mandatoryAttributes.add(ATTR_NAME);
    }

    public static void write(Collection<ConnectionParameters> connectionConfigs, OutputStream outputStream) throws IOException, IllegalArgumentException {
        try {
            CollectionUtils.map(connectionConfigs, new Function<ConnectionParameters, String>(){

                @Override
                public String evaluate(ConnectionParameters v) {
                    return v.getId();
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element connectionsElement = document.createElement(CONN);
            document.appendChild(connectionsElement);
            Map<String, List<ConnectionParameters>> connectionsByConnectionType = ConnectionsXMLSerializer.byConnectionType(connectionConfigs);
            ConnectionsXMLSerializer.addTypes(document, connectionsElement, connectionsByConnectionType);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(new DOMSource(document), result);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static void addTypes(Document document, Element connectionsElement, Map<String, List<ConnectionParameters>> connectionsByConnectionType) {
        for (Map.Entry<String, List<ConnectionParameters>> connectionType : connectionsByConnectionType.entrySet()) {
            Element typeElement = document.createElement(TYPE);
            connectionsElement.appendChild(typeElement);
            typeElement.setAttribute(TYPE, connectionType.getKey());
            ConnectionsXMLSerializer.addConfigs(document, typeElement, connectionType.getValue());
        }
    }

    private static void addConfigs(Document document, Element typeElement, List<ConnectionParameters> connectionsByConnectionType) {
        for (ConnectionParameters configuration : connectionsByConnectionType) {
            Element configElement = document.createElement(ATTR_ID);
            ConnectionsXMLSerializer.addConfig(typeElement, configuration, configElement);
        }
    }

    private static void addConfig(Element typeElement, ConnectionParameters configuration, Element configElement) {
        configElement.setAttribute(ATTR_ID, configuration.getId());
        configElement.setAttribute(ATTR_NAME, configuration.getName());
        for (Map.Entry<String, String> attribute : configuration.getAttributes().entrySet()) {
            configElement.setAttribute(attribute.getKey(), attribute.getValue());
        }
        typeElement.appendChild(configElement);
    }

    public static List<ConnectionParameters> read(InputStream inputStream) throws IOException {
        ArrayList<ConnectionParameters> configurations = new ArrayList<ConnectionParameters>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodes = (NodeList)typesExpression.evaluate(document, XPathConstants.NODESET);
            int i = 0;
            while (i < nodes.getLength()) {
                Element typeElement = (Element)nodes.item(i);
                String type = typeElement.getAttribute(TYPE);
                NodeList configNodes = (NodeList)configsExpression.evaluate(typeElement, XPathConstants.NODESET);
                int j = 0;
                while (j < configNodes.getLength()) {
                    Element configElement = (Element)configNodes.item(j);
                    ConnectionParameters config = ConnectionsXMLSerializer.readConfiguration(configElement, type);
                    configurations.add(config);
                    ++j;
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
        try {
            ConnectionsXMLSerializer.fixDuplicateIDs(configurations);
        }
        catch (IllegalArgumentException ex) {
            debug.warning("read", "Failed to deserialize connections due to duplicate IDs", (Throwable)ex);
            throw new IOException(Messages.ConnectionsXMLSerializer_duplicateIds, ex);
        }
        return configurations;
    }

    public static void fixDuplicateIDs(List<ConnectionParameters> configurations) {
        List<List<ConnectionParameters>> groupedById = CollectionUtils.groupBy(configurations, new Function<ConnectionParameters, String>(){

            @Override
            public String evaluate(ConnectionParameters v) {
                return v.getId();
            }
        });
        List<List<ConnectionParameters>> duplicateIds = CollectionUtils.filter(groupedById, new Function<List<ConnectionParameters>, Boolean>(){

            @Override
            public Boolean evaluate(List<ConnectionParameters> v) {
                if (v.size() > 1) {
                    return true;
                }
                return false;
            }
        });
        List<Map<String, ConnectionParameters>> duplicateIdsIndexedByTypePlusId = CollectionUtils.transform(duplicateIds, new Function<List<ConnectionParameters>, Map<String, ConnectionParameters>>(){

            @Override
            public Map<String, ConnectionParameters> evaluate(List<ConnectionParameters> v) {
                return CollectionUtils.map(v, new Function<ConnectionParameters, String>(){

                    @Override
                    public String evaluate(ConnectionParameters v) {
                        return String.valueOf(v.getId()) + ":" + v.getConnectionTypeId();
                    }
                });
            }
        });
        HashMap<ConnectionParameters, ConnectionParameters> replacements = new HashMap<ConnectionParameters, ConnectionParameters>();
        for (Map<String, ConnectionParameters> map : duplicateIdsIndexedByTypePlusId) {
            for (Map.Entry<String, ConnectionParameters> entry : map.entrySet()) {
                replacements.put(entry.getValue(), entry.getValue().setId(entry.getKey()));
            }
        }
        ListIterator<ConnectionParameters> listIterator = configurations.listIterator();
        while (listIterator.hasNext()) {
            ConnectionParameters next = listIterator.next();
            if (!replacements.containsKey(next)) continue;
            listIterator.set((ConnectionParameters)replacements.get(next));
        }
    }

    private static ConnectionParameters readConfiguration(Element configElement, String type) {
        String id = ConnectionsXMLSerializer.getAttributeValue(configElement, ATTR_ID);
        String name = ConnectionsXMLSerializer.getAttributeValue(configElement, ATTR_NAME);
        ArrayList<ConnectionParameters.AttributeValue> attributeValues = new ArrayList<ConnectionParameters.AttributeValue>();
        NamedNodeMap attributes = configElement.getAttributes();
        int k = 0;
        while (k < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(k);
            if (ConnectionsXMLSerializer.isExtendedAttribute(attribute)) {
                attributeValues.add(ConnectionParameters.av(attribute.getName(), attribute.getValue()));
            }
            ++k;
        }
        ConnectionParameters config = new ConnectionParameters(id, name, type, attributeValues.toArray(new ConnectionParameters.AttributeValue[0]));
        return config;
    }

    private static boolean isExtendedAttribute(Attr attribute) {
        return !mandatoryAttributes.contains(attribute.getName());
    }

    private static String getAttributeValue(Element element, String attributeName) {
        return element.hasAttribute(attributeName) ? element.getAttribute(attributeName) : null;
    }

    private static Map<String, List<ConnectionParameters>> byConnectionType(Collection<ConnectionParameters> connectionConfigs) {
        List<List<ConnectionParameters>> list = CollectionUtils.groupBy(connectionConfigs, new Function<ConnectionParameters, String>(){

            @Override
            public String evaluate(ConnectionParameters v) {
                return v.getConnectionTypeId();
            }
        });
        return CollectionUtils.map(list, new Function<List<ConnectionParameters>, String>(){

            @Override
            public String evaluate(List<ConnectionParameters> v) {
                return v.get(0).getConnectionTypeId();
            }
        });
    }
}

