/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.comm.internal.ConnectionDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class FilteredConnectionRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ConnectionRegistry connectionRegistry;

    public FilteredConnectionRegistry(ConnectionRegistry connectionRegistry) {
        this.connectionRegistry = connectionRegistry;
    }

    public IConnectionDescriptor find(String connectionId) {
        IConnectionDescriptor descriptor = this.connectionRegistry.find(connectionId);
        if (descriptor != null && FilteredConnectionRegistry.filter(descriptor)) {
            descriptor = null;
        }
        return descriptor;
    }

    public IConnectionDescriptor[] getConnections() {
        IConnectionDescriptor[] descriptors = this.connectionRegistry.getConnections();
        IConnectionDescriptor[] result = (IConnectionDescriptor[])FilteredConnectionRegistry.filterArray(descriptors);
        return result;
    }

    public IConnectionCategory findCategory(Class connectionType) {
        return this.connectionRegistry.findCategory(connectionType);
    }

    public IConnectionCategory findCategory(String connectionCategoryId) {
        return this.connectionRegistry.findCategory(connectionCategoryId);
    }

    public IConnectionCategory[] getConnectionCategories() {
        return this.connectionRegistry.getConnectionCategories();
    }

    private static Object[] filterArray(IConnectionDescriptor[] array) {
        ArrayList<IConnectionDescriptor> result = new ArrayList<IConnectionDescriptor>(array.length);
        int i = 0;
        while (i < array.length) {
            if (!FilteredConnectionRegistry.filter(array[i])) {
                result.add(array[i]);
            }
            ++i;
        }
        return result.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), result.size()));
    }

    private static boolean filter(IConnectionDescriptor descriptor) {
        if (descriptor instanceof ConnectionDescriptor) {
            final ConnectionDescriptor connDesc = (ConnectionDescriptor)descriptor;
            IPluginContribution pc = new IPluginContribution(){

                public String getLocalId() {
                    return connDesc.getId();
                }

                public String getPluginId() {
                    if (connDesc.getElement() != null && connDesc.getElement().getContributor() != null) {
                        return connDesc.getElement().getContributor().getName();
                    }
                    return "????";
                }
            };
            return WorkbenchActivityHelper.filterItem((Object)pc);
        }
        return false;
    }
}

