/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.AbstractConnectionProvider;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class ReadableConnectionProvider
extends AbstractConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IConnectionDeserializer deserializer;
    private IStatus status = Status.OK_STATUS;

    public ReadableConnectionProvider(String id, IConnectionDeserializer deserializer, ConnectionRegistry registry) {
        super(id, registry);
        this.deserializer = deserializer;
    }

    @Override
    protected List<ConnectionParameters> getUpdatedConfigurations(IProgressMonitor monitor) {
        try {
            List<ConnectionParameters> list = this.deserializer.load();
            this.status = Status.OK_STATUS;
            return list;
        }
        catch (IOException ex) {
            this.status = new Status(4, "com.ibm.cics.core.connections", ex.getMessage(), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }
}

