/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.StreamNameReference;
import com.ibm.cics.core.model.StreamNameType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IStreamName;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableStreamName;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableStreamName
extends MutableCICSResource
implements IMutableStreamName {
    private IStreamName delegate;
    private MutableSMRecord record;

    public MutableStreamName(ICPSM cpsm, IContext context, IStreamName cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("STREAMNM");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getStreamname() {
        return this.delegate.getStreamname();
    }

    public IStreamName.StatusValue getStatus() {
        return this.delegate.getStatus();
    }

    public IStreamName.SystemlogValue getSystemlog() {
        return this.delegate.getSystemlog();
    }

    public Long getUsecount() {
        return this.delegate.getUsecount();
    }

    public Long getWrites() {
        return this.delegate.getWrites();
    }

    public Long getBytes() {
        return this.delegate.getBytes();
    }

    public Long getCufwtrs() {
        return this.delegate.getCufwtrs();
    }

    public Long getPkfwtrs() {
        return this.delegate.getPkfwtrs();
    }

    public Long getTfcwait() {
        return this.delegate.getTfcwait();
    }

    public Long getBuffwait() {
        return this.delegate.getBuffwait();
    }

    public Long getBrwstrt() {
        return this.delegate.getBrwstrt();
    }

    public Long getBrwread() {
        return this.delegate.getBrwread();
    }

    public Long getDeletes() {
        return this.delegate.getDeletes();
    }

    public Long getRetryerrs() {
        return this.delegate.getRetryerrs();
    }

    public Long getBufappndrq() {
        return this.delegate.getBufappndrq();
    }

    public IStreamName.DasdonlyValue getDasdonly() {
        return this.delegate.getDasdonly();
    }

    public String getStrcname() {
        return this.delegate.getStrcname();
    }

    public Long getMaxblk() {
        return this.delegate.getMaxblk();
    }

    public Long getRetpd() {
        return this.delegate.getRetpd();
    }

    public IStreamName.AutodelValue getAutodel() {
        return this.delegate.getAutodel();
    }

    public Long getLggakpfreq() {
        String result = this.record.get("LGGAKPFREQ");
        if (result == null) {
            return this.delegate.getLggakpfreq();
        }
        return (Long)((CICSAttribute)StreamNameType.LGGAKPFREQ).get(result, this.record.getNormalizers());
    }

    public Long getLgglgdefer() {
        String result = this.record.get("LGGLGDEFER");
        if (result == null) {
            return this.delegate.getLgglgdefer();
        }
        return (Long)((CICSAttribute)StreamNameType.LGGLGDEFER).get(result, this.record.getNormalizers());
    }

    public Long getLggakpstkn() {
        return this.delegate.getLggakpstkn();
    }

    public Long getLgsqueries() {
        return this.delegate.getLgsqueries();
    }

    public String getRwrites() {
        return this.delegate.getRwrites();
    }

    public void setLggakpfreq(Long _lggakpfreq) {
        if (_lggakpfreq.equals(this.delegate.getLggakpfreq())) {
            this.record.set("LGGAKPFREQ", null);
        } else {
            StreamNameType.LGGAKPFREQ.validate((Object)_lggakpfreq);
            String connectionSpecificExternalValue = ((CICSAttribute)StreamNameType.LGGAKPFREQ).set(_lggakpfreq, this.record.getNormalizers());
            this.record.set("LGGAKPFREQ", connectionSpecificExternalValue);
        }
    }

    public void setLgglgdefer(Long _lgglgdefer) {
        if (_lgglgdefer.equals(this.delegate.getLgglgdefer())) {
            this.record.set("LGGLGDEFER", null);
        } else {
            StreamNameType.LGGLGDEFER.validate((Object)_lgglgdefer);
            String connectionSpecificExternalValue = ((CICSAttribute)StreamNameType.LGGLGDEFER).set(_lgglgdefer, this.record.getNormalizers());
            this.record.set("LGGLGDEFER", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == StreamNameType.STREAMNAME) {
            return (V)this.getStreamname();
        }
        if (attribute == StreamNameType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == StreamNameType.SYSTEMLOG) {
            return (V)this.getSystemlog();
        }
        if (attribute == StreamNameType.USECOUNT) {
            return (V)this.getUsecount();
        }
        if (attribute == StreamNameType.WRITES) {
            return (V)this.getWrites();
        }
        if (attribute == StreamNameType.BYTES) {
            return (V)this.getBytes();
        }
        if (attribute == StreamNameType.CUFWTRS) {
            return (V)this.getCufwtrs();
        }
        if (attribute == StreamNameType.PKFWTRS) {
            return (V)this.getPkfwtrs();
        }
        if (attribute == StreamNameType.TFCWAIT) {
            return (V)this.getTfcwait();
        }
        if (attribute == StreamNameType.BUFFWAIT) {
            return (V)this.getBuffwait();
        }
        if (attribute == StreamNameType.BRWSTRT) {
            return (V)this.getBrwstrt();
        }
        if (attribute == StreamNameType.BRWREAD) {
            return (V)this.getBrwread();
        }
        if (attribute == StreamNameType.DELETES) {
            return (V)this.getDeletes();
        }
        if (attribute == StreamNameType.RETRYERRS) {
            return (V)this.getRetryerrs();
        }
        if (attribute == StreamNameType.BUFAPPNDRQ) {
            return (V)this.getBufappndrq();
        }
        if (attribute == StreamNameType.DASDONLY) {
            return (V)this.getDasdonly();
        }
        if (attribute == StreamNameType.STRCNAME) {
            return (V)this.getStrcname();
        }
        if (attribute == StreamNameType.MAXBLK) {
            return (V)this.getMaxblk();
        }
        if (attribute == StreamNameType.RETPD) {
            return (V)this.getRetpd();
        }
        if (attribute == StreamNameType.AUTODEL) {
            return (V)this.getAutodel();
        }
        if (attribute == StreamNameType.LGGAKPFREQ) {
            return (V)this.getLggakpfreq();
        }
        if (attribute == StreamNameType.LGGLGDEFER) {
            return (V)this.getLgglgdefer();
        }
        if (attribute == StreamNameType.LGGAKPSTKN) {
            return (V)this.getLggakpstkn();
        }
        if (attribute == StreamNameType.LGSQUERIES) {
            return (V)this.getLgsqueries();
        }
        if (attribute == StreamNameType.RWRITES) {
            return (V)this.getRwrites();
        }
        return super.getAttributeValue(attribute);
    }

    public StreamNameType getObjectType() {
        return StreamNameType.getInstance();
    }

    @Override
    public StreamNameReference getCICSObjectReference() {
        return new StreamNameReference(this.getCICSContainer(), this.getStreamname());
    }
}

