/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.comm.internal.ConnectionCategory;
import com.ibm.cics.core.comm.internal.ConnectionDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ConnectionRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String TAG_CONNECTION = "connection";
    private static final String TAG_CATEGORY = "category";
    private static final Debug debug = new Debug(ConnectionRegistry.class);
    private static ConnectionRegistry registry;
    private Set<IConnectionDescriptor> connections = new HashSet<IConnectionDescriptor>();
    private Set<IConnectionCategory> categories = new HashSet<IConnectionCategory>();

    private ConnectionRegistry() {
    }

    private void init() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cics.core.comm", "connections");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
        this.mapConnectionsToCategories();
    }

    private void mapConnectionsToCategories() {
        for (IConnectionDescriptor descriptor : this.connections) {
            ((ConnectionCategory)descriptor.getCategory()).addConnection(descriptor);
        }
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
    }

    private void readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_CONNECTION)) {
            this.readConnection(element);
        } else if (element.getName().equals(TAG_CATEGORY)) {
            this.readCategory(element);
        }
    }

    private void readConnection(IConfigurationElement element) {
        debug.enter("readConnection", (Object)element);
        ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
        connectionDescriptor.setConfigurationElement(element);
        this.connections.add(connectionDescriptor);
        debug.exit("readConnection", (Object)("added: " + connectionDescriptor));
    }

    private void readCategory(IConfigurationElement element) {
        this.categories.add(new ConnectionCategory(element));
    }

    public IConnectionCategory findCategory(Class<? extends IConnection> connectionType) {
        debug.enter("findCategory", connectionType);
        for (IConnectionCategory category : this.categories) {
            try {
                Class<? extends IConnection> categoryConnectionClass = category.getType();
                if (!categoryConnectionClass.isAssignableFrom(connectionType)) continue;
                debug.exit("findCategory", (Object)("return: " + category));
                return category;
            }
            catch (ClassNotFoundException e) {
                debug.error("findCategory", "couldn't determine category class for category \"" + category.getId() + "\"", (Throwable)e);
                debug.error("findCategory", "couldn't determine category class for category \"" + category.getId() + "\"");
            }
        }
        debug.exit("findCategory", (Object)"return: null");
        return null;
    }

    public IConnectionDescriptor find(String id) {
        debug.enter("find", (Object)id);
        for (IConnectionDescriptor connection : this.connections) {
            if (!connection.getId().equals(id)) continue;
            debug.exit("find", (Object)("return: " + connection));
            return connection;
        }
        return null;
    }

    public IConnectionDescriptor[] getConnections() {
        return this.connections.toArray(new IConnectionDescriptor[this.connections.size()]);
    }

    public IConnectionCategory[] getConnectionCategories() {
        return this.categories.toArray(new IConnectionCategory[this.categories.size()]);
    }

    @Deprecated
    public IConnectionCategory findCategory(String id) {
        for (IConnectionCategory connectionCategory : this.categories) {
            if (!connectionCategory.getId().equals(id)) continue;
            return connectionCategory;
        }
        return null;
    }

    public static synchronized ConnectionRegistry getConnectionRegistry() {
        if (registry == null) {
            registry = new ConnectionRegistry();
            registry.init();
        }
        return registry;
    }

    public IConnectionCategory getConnectionCategory(String aCategoryID) {
        IConnectionCategory[] iConnectionCategoryArray = this.getConnectionCategories();
        int n = iConnectionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionCategory category = iConnectionCategoryArray[n2];
            if (category.getId().equals(aCategoryID)) {
                return category;
            }
            ++n2;
        }
        return null;
    }
}

