/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.Activator;
import com.ibm.cics.core.comm.ExplorerHostnameVerifier;
import com.ibm.cics.core.comm.IPassphraseManager;
import com.ibm.cics.core.comm.SSLProtocolEnablerDecorator;
import com.ibm.cics.core.comm.SecureCertificateException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Platform;

public class ExplorerSecurityHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ExplorerSecurityHelper.class);
    private X509TrustManager defaultTrustManager;
    private X509KeyManager defaultKeyManager;
    private KeyStore ts;
    private KeyStore ks;
    private String name;
    private String host;
    private static IPassphraseManager passphraseManager;

    private ExplorerSecurityHelper(String tsfileString, String tspassPhrase, String tsdbType, String ksfileString, String kspassPhrase, String ksdbType) throws GeneralSecurityException, IOException {
        debug.enter("ExplorerSecurityHelper");
        if (!Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
            this.ts = KeyStore.getInstance(tsdbType);
            this.ts.load(new FileInputStream(tsfileString), tspassPhrase.toCharArray());
            TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            defaultTrustManagerFactory.init(this.ts);
            TrustManager[] trustManagerArray = defaultTrustManagerFactory.getTrustManagers();
            int n = trustManagerArray.length;
            int n2 = 0;
            while (n2 < n) {
                TrustManager trustmanager = trustManagerArray[n2];
                if (trustmanager instanceof X509TrustManager && this.defaultTrustManager == null) {
                    this.defaultTrustManager = (X509TrustManager)trustmanager;
                }
                ++n2;
            }
            this.ks = KeyStore.getInstance(ksdbType);
            this.ks.load(new FileInputStream(ksfileString), kspassPhrase.toCharArray());
            KeyManagerFactory defaultKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            defaultKeyManagerFactory.init(this.ks, kspassPhrase.toCharArray());
            KeyManager[] keyManagerArray = defaultKeyManagerFactory.getKeyManagers();
            int n3 = keyManagerArray.length;
            n = 0;
            while (n < n3) {
                KeyManager keymanager = keyManagerArray[n];
                if (keymanager instanceof X509KeyManager && this.defaultKeyManager == null) {
                    this.defaultKeyManager = (X509KeyManager)keymanager;
                }
                ++n;
            }
        }
        debug.exit("ExplorerTrustManager", (Object)this.defaultKeyManager);
    }

    ExplorerSecurityHelper() throws GeneralSecurityException, IOException {
        this(ExplorerSecurityHelper.getCurrentTrustStore(), ExplorerSecurityHelper.getCurrentTrustStorePassphrase(), Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.dbType", "", null), ExplorerSecurityHelper.getCurrentKeyStore(), ExplorerSecurityHelper.getCurrentKeyStorePassphrase(), Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.keystore.dbType", "", null));
    }

    private ExplorerSecurityHelper(String name, String host) throws GeneralSecurityException, IOException {
        this(ExplorerSecurityHelper.getCurrentTrustStore(), ExplorerSecurityHelper.getCurrentTrustStorePassphrase(), Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.dbType", "", null), ExplorerSecurityHelper.getCurrentKeyStore(), ExplorerSecurityHelper.getCurrentKeyStorePassphrase(), Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.keystore.dbType", "", null));
        this.host = host;
        this.name = name;
    }

    public static String validateStoreDetail(String tsfileString, String tspassPhrase, String tsdbType, String ksfileString, String kspassPhrase, String ksdbType) {
        String response;
        block9: {
            debug.enter("validateStoreDetail");
            response = "";
            try {
                KeyStore ts1 = KeyStore.getInstance(tsdbType);
                ts1.load(new FileInputStream(tsfileString), tspassPhrase.toCharArray());
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                defaultTrustManagerFactory.init(ts1);
                if (ts1.size() == 0) {
                    throw new IOException("Invalid_store_format_message");
                }
                KeyStore ks1 = KeyStore.getInstance(ksdbType);
                ks1.load(new FileInputStream(ksfileString), kspassPhrase.toCharArray());
                KeyManagerFactory defaultKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                defaultKeyManagerFactory.init(ks1, kspassPhrase.toCharArray());
                if (ks1.size() == 0) {
                    throw new IOException("Invalid_store_format_message");
                }
            }
            catch (GeneralSecurityException gsex) {
                response = gsex.getMessage();
            }
            catch (FileNotFoundException ex) {
                response = ex.getMessage();
                if (response.length() == 0) {
                    response = ex.toString();
                }
            }
            catch (EOFException fnfe) {
                response = fnfe.getMessage();
                if (!StringUtil.hasContent((String)response)) {
                    response = fnfe.toString();
                }
            }
            catch (IOException ioe) {
                response = ioe.getMessage();
                if (response.length() != 0) break block9;
                response = ioe.toString();
            }
        }
        debug.exit("validateStoreDetail", (Object)response);
        return response;
    }

    private static String validateTrustStoreDetail(String tsfileString, String tspassPhrase, String tsdbType) {
        String response;
        block7: {
            debug.enter("validateTrustStoreDetail");
            response = "";
            try {
                KeyStore ts1 = KeyStore.getInstance(tsdbType);
                ts1.load(new FileInputStream(tsfileString), tspassPhrase.toCharArray());
                TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                defaultTrustManagerFactory.init(ts1);
                File f = new File(tsfileString);
                if (!f.canWrite()) {
                    f.setWritable(true);
                    ts1.store(new FileOutputStream(tsfileString), tspassPhrase.toCharArray());
                    f.setWritable(false);
                } else {
                    ts1.store(new FileOutputStream(tsfileString), tspassPhrase.toCharArray());
                }
            }
            catch (GeneralSecurityException gsex) {
                response = gsex.getMessage();
            }
            catch (FileNotFoundException ex) {
                response = ex.getMessage();
                if (response.length() == 0) {
                    response = ex.toString();
                }
            }
            catch (IOException fnfe) {
                response = fnfe.getMessage();
                if (!response.startsWith("DerInputStream")) break block7;
                response = String.valueOf(response) + "- possible invalid DB type";
            }
        }
        debug.exit("validateTrustStoreDetail", (Object)response);
        return response;
    }

    public static String validateTrustStoreDetail() {
        String dbType = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.dbType", "", null);
        return ExplorerSecurityHelper.validateTrustStoreDetail(ExplorerSecurityHelper.getCurrentTrustStore(), ExplorerSecurityHelper.getCurrentTrustStorePassphrase(), dbType);
    }

    public static String getCurrentTrustStore() {
        return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.trustStore", "", null);
    }

    public static String getCurrentTrustStorePassphrase() {
        debug.enter("getCurrentTrustStorePassphrase");
        if (passphraseManager == null) {
            debug.event("getCurrentTrustStorePassphrase", "manager is null");
            return "changeit";
        }
        debug.exit("getCurrentTrustStorePassphrase");
        return passphraseManager.getTrustStorePassphrase();
    }

    public static String getCurrentKeyStore() {
        return Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "javax.net.ssl.keyStore", "", null);
    }

    public static String getCurrentKeyStorePassphrase() {
        debug.enter("getCurrentKeyStorePassphrase");
        if (passphraseManager == null) {
            debug.event("getCurrentTrustStorePassphrase", "manager is null");
            return "changeit";
        }
        debug.exit("getCurrentKeyStorePassphrase");
        return passphraseManager.getKeyStorePassphrase();
    }

    public static void setPassphraseManager(IPassphraseManager passphraseManager) {
        debug.enter("setPassphraseManager");
        ExplorerSecurityHelper.passphraseManager = passphraseManager;
        debug.exit("setPassphraseManager");
    }

    private static Object[] getSSLContext(String name, String host) throws IOException {
        try {
            SSLContext sslContext;
            Boolean enableExtraTLSProtocols = false;
            String protocol = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.security.protocol", "", null);
            if (StringUtil.hasContent((String)protocol)) {
                sslContext = SSLContext.getInstance(protocol);
            } else {
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    enableExtraTLSProtocols = true;
                }
                catch (NoSuchAlgorithmException e) {
                    debug.warning("initialiseContext", (Object)e);
                    sslContext = SSLContext.getInstance("SSL");
                }
            }
            ExplorerSecurityHelper mgr = new ExplorerSecurityHelper(name, host);
            sslContext.init(new KeyManager[]{mgr.getKeyManager()}, new TrustManager[]{mgr.getTrustManager()}, new SecureRandom());
            debug.event("getSSLContext", ExplorerSecurityHelper.getPrintableEnabledProtocols(sslContext));
            return new Object[]{sslContext, enableExtraTLSProtocols};
        }
        catch (KeyManagementException e) {
            debug.error("initialiseContext", (Throwable)e);
            throw new IOException(e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            debug.error("initialiseContext", (Throwable)e);
            throw new IOException(e.toString());
        }
        catch (GeneralSecurityException e) {
            debug.error("initialiseContext", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    public static SSLContext setUpSSlContextAndInitialiseHostnameVerifier(String name, String host) throws IOException {
        Object[] sslContextArr = ExplorerSecurityHelper.getSSLContext(name, host);
        SSLSocketFactory socketFactory = ExplorerSecurityHelper.getSSLSocketFactory((SSLContext)sslContextArr[0], (Boolean)sslContextArr[1]);
        debug.enter("setUpSSlContextAndInitialiseHostnameVerifier");
        HttpsURLConnection.setDefaultHostnameVerifier(new ExplorerHostnameVerifier());
        HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        debug.exit("setUpSSlContextAndInitialiseHostnameVerifier", sslContextArr[0]);
        return (SSLContext)sslContextArr[0];
    }

    private static SSLSocketFactory getSSLSocketFactory(SSLContext context, boolean enableExtraTLSProtocols) {
        return new SSLProtocolEnablerDecorator(context.getSocketFactory(), enableExtraTLSProtocols);
    }

    public static SSLSocketFactory getSSLSocketFactory(String name, String host) throws IOException {
        Object[] sslContext = ExplorerSecurityHelper.getSSLContext(name, host);
        return ExplorerSecurityHelper.getSSLSocketFactory((SSLContext)sslContext[0], (Boolean)sslContext[1]);
    }

    private static String getPrintableEnabledProtocols(SSLContext sslContext) {
        StringBuffer sb = new StringBuffer();
        sb.append("Enabled protocols in SSLEngine (specified \"" + sslContext.getProtocol() + "\"): [");
        String[] stringArray = sslContext.createSSLEngine().getEnabledProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pro = stringArray[n2];
            sb.append(String.valueOf(pro) + ", ");
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }

    X509TrustManager getTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                debug.enter("checkClientTrusted", (Object)chain, (Object)authType);
                if (!Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
                    ExplorerSecurityHelper.this.defaultTrustManager.checkClientTrusted(chain, authType);
                }
                debug.exit("checkClientTrusted");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                block3: {
                    debug.enter("checkServerTrusted", (Object)chain, (Object)authType);
                    if (!Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
                        try {
                            ExplorerSecurityHelper.this.defaultTrustManager.checkServerTrusted(chain, authType);
                        }
                        catch (CertificateException cex) {
                            if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) break block3;
                            throw new SecureCertificateException(cex, chain, ExplorerSecurityHelper.this.name, ExplorerSecurityHelper.this.host);
                        }
                    }
                }
                debug.exit("checkServerTrusted");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                debug.enter("getAcceptedIssuers");
                X509Certificate[] resp = new X509Certificate[]{};
                if (!Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
                    resp = ExplorerSecurityHelper.this.defaultTrustManager.getAcceptedIssuers();
                }
                debug.exit("getAcceptedIssuers", (Object)resp);
                return resp;
            }
        };
    }

    private X509ExtendedKeyManager getKeyManager() {
        return new X509ExtendedKeyManager(){

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                debug.enter("getServerAliases", (Object)keyType, (Object)issuers);
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
                    String[] stringArray = new String[]{};
                }
                String[] resp = ExplorerSecurityHelper.this.defaultKeyManager.getServerAliases(keyType, issuers);
                debug.exit("getServerAliases", (Object)resp);
                return resp;
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                debug.enter("getPrivateKey", (Object)alias);
                PrivateKey pk = null;
                Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null);
                pk = ExplorerSecurityHelper.this.defaultKeyManager.getPrivateKey(alias);
                debug.exit("getPrivateKey", (Object)pk);
                return pk;
            }

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                debug.enter("getClientAliases", (Object)keyType, (Object)issuers);
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null)) {
                    String[] stringArray = new String[]{};
                }
                String[] resp = ExplorerSecurityHelper.this.defaultKeyManager.getClientAliases(keyType, issuers);
                debug.exit("getClientAliases", (Object)resp);
                return resp;
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                debug.enter("getCertificateChain", (Object)alias);
                X509Certificate[] resp = null;
                Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null);
                resp = ExplorerSecurityHelper.this.defaultKeyManager.getCertificateChain(alias);
                debug.exit("getCertificateChain", (Object)resp);
                return resp;
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                debug.enter("chooseServerAlias", (Object)keyType, (Object)issuers);
                String resp = null;
                Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null);
                resp = ExplorerSecurityHelper.this.defaultKeyManager.chooseServerAlias(keyType, issuers, socket);
                debug.exit("chooseServerAlias", (Object)resp);
                return resp;
            }

            @Override
            public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                debug.enter("chooseClientAlias", (Object)keyType, (Object)issuers);
                String resp = null;
                Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.core.comm.truststore.ignore", false, null);
                resp = ExplorerSecurityHelper.this.defaultKeyManager.chooseClientAlias(keyType, issuers, socket);
                debug.exit("chooseClientAlias", (Object)resp);
                return resp;
            }
        };
    }
}

