/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="3096089560" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import java.text.MessageFormat
import com.ibm.cics.core.model.CICSCore
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection
import com.ibm.cics.sm.comm.sm.SMConnection
import com.ibm.cics.ucd.CMCIConnectionHelper
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.properties.PropertyException;
import com.urbancode.air.AirPluginTool;

abstract class CICSStep extends Step {
// <copyright 
// notice="cics-rm-source-program" 
// pids="CA0U" 
// years="2014,2015" 
// crc="1281828460" > 
// 	Licensed Materials - Property of IBM 
// 	"Restricted Materials of IBM" 
// 	CA0U 
// 	(C) Copyright IBM Corp. 2014, 2015 
// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
// </copyright> 
	public static final String RESOURCE_TYPE="resourceType";
	public static final String ACTION_TYPE="actionType";
	protected ICPSM cpsm
	
	public CICSStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}
	
	public CICSStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	CICSStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}
	
	CICSStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}
		
	@Override
	protected void runStep() {
		def CMCIConnectionHelper connHelper = createCMCIConnectionHelper()
		ISystemManagerConnection conn = connHelper.establishCMCIConnection()
		
		//If the step does not support SMSS but the connection is SMSS
		//An error message is returned to user and step is failed before any logic run
		if(!supportedOnNonCICSplex() && !connHelper.isCICSplex(conn)){
			 log(MessageFormat.format(CICSUCDMessage.notCPSMEnv))
			 throw new StepFailedException("Step failed.");
		}
		
		cpsm.setConnection(conn)
		IContext context = connHelper.getContext(conn)
		
		runCICSStep(cpsm, context)
	}
	
	protected boolean supportedOnNonCICSplex() {
		return true
	}
	
	protected CMCIConnectionHelper createCMCIConnectionHelper() throws PropertyException {
		return new CMCIConnectionHelper(apTool.getStepProperties())
	}
	
	protected abstract void runCICSStep(ICPSM cpsm, IContext context);
}
