/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2015"                                                       */
/* crc="2586535355" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2015                                      */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSCore;

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.ProgramType
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.properties.IntegerProperty;
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.properties.ResourceNameListPropertySupportWildCard
import com.urbancode.air.AirPluginTool;
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import java.text.MessageFormat
import com.ibm.cics.core.model.CICSObjectPrimaryKey

class DiscardResourceStep extends CICSStep {
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2015" 
	// crc="3514276934" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 

	public DiscardResourceStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}

	public DiscardResourceStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	DiscardResourceStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}

	DiscardResourceStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}

	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {


		def props = apTool.getStepProperties()
		def cpsmHelper = new CPSMHelper()

		//Resource type is a list from the stepUI -- user should choose from the dropdown list
		def resourceType = props[RESOURCE_TYPE]

		//Get the resource type from given property 'resourceType'
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceType)
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)

		def resourceNameList = new ResourceNameListProperty(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType, cpsmHelper.isNameCaseSensitive(resourceType), true).parse(props['resourceNameList']).getValue()

		//For step execution status use
		boolean stepFail = false
		int successCount = 0
		int failCount = 0

		//Issue message to start the step execution
		log(MessageFormat.format(CICSUCDMessage.PERFORM, SystemManagerActions.Discard.getActionName()))

		//Iterate to discard each resource
		for(int i=0; i < resourceNameList.size(); i++) {
			try {
				//Invoke specific method to discard the resource
				boolean discardSuccess = cpsmHelper.discard(cpsm, type, context, resourceNameList.get(i))
				if(discardSuccess)
					successCount++

			} catch (CICSSystemManagerException e) {
				//Any exception thrown in the discard process handled here
				failCount++
				stepFail = true
				cpsmHelper.handleException(e, resourceType, SystemManagerActions.Discard, resourceNameList.get(i),errorList)
			}

		}

		log(MessageFormat.format(CICSUCDMessage.resultSummary, SystemManagerActions.Discard.getActionName(), Integer.toString(successCount), Integer.toString(failCount)))

		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}

	}

}
