/*<copyright                                                          */
/* notice="cics-rm-source-program"                                    */
/* pids="CA0U"                                                        */
/* years="2014,2015"                                                  */
/* crc="2003615079" >                                                 */
/* 	Licensed Materials - Property of IBM                              */
/* 	"Restricted Materials of IBM"                                     */
/* 	CA0U                                                              */
/* 	(C) Copyright IBM Corp. 2014, 2015                                */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                                       */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSSystemManagerException
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.properties.ResourceNameListProperty
import com.ibm.cics.ucd.steplabel.CICSUCDStepLabel
import com.ibm.cics.ucd.msg.CICSUCDMessage
import com.urbancode.air.AirPluginTool;

import java.text.MessageFormat

class InstallGroupOrListFromCSDStep extends CICSStep{
	// <copyright 
	// notice="cics-rm-source-program" 
	// pids="CA0U" 
	// years="2014,2015" 
	// crc="51468939" > 
	// 	Licensed Materials - Property of IBM 
	// 	"Restricted Materials of IBM" 
	// 	CA0U 
	// 	(C) Copyright IBM Corp. 2014, 2015 
	// 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
	// </copyright> 
	
	public InstallGroupOrListFromCSDStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}
	
	public InstallGroupOrListFromCSDStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	InstallGroupOrListFromCSDStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}
	
	InstallGroupOrListFromCSDStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}

	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {
		def cpsmHelper = new CPSMHelper()
		def props = apTool.getStepProperties()
		def resourceType = props['groupOrList']
		def groupOrListNameList = new ResourceNameListProperty(CICSUCDStepLabel.RESOURCE_NAME_LIST, resourceType, false, true).parse(props['groupOrListNameList']).getValue()
		//Resource type is a list from the stepUI -- No user input
		
		
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName(resourceType)
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)	
		
		//For step execution status use
		boolean stepFail = false
		int successCount = 0
		int failCount = 0
		
		//Issue message to start the step execution
		log(MessageFormat.format(CICSUCDMessage.installfromCSD))
		
		//Iterate to install each resource
		for(int i=0; i < groupOrListNameList.size(); i++) {
			try {
				//Invoke specific method to install the resource
				boolean installSuccess = cpsmHelper.installCSDGroupOrList(cpsm, type, context, groupOrListNameList.get(i))
				if(installSuccess)
					successCount++
		
			} catch (CICSSystemManagerException e) {
				//Any exception thrown in the install process handled here
				failCount++
				stepFail = true
				cpsmHelper.handleException(e, resourceType, SystemManagerActions.Install, groupOrListNameList.get(i),errorList)
			}
		
		}
		
		log(MessageFormat.format(CICSUCDMessage.resultSummary, 'INSTALL', Integer.toString(successCount), Integer.toString(failCount)))
		
		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}
				
		
	}

}
