/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;

public class ConnectedState
implements IConnectionState {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IConnection connection;
    private ConnectionProfile configuration;

    protected ConnectedState(IConnection aConnection, ConnectionProfile aConfiguration) {
        if (aConnection == null) {
            throw new NullPointerException("ConnectedState(IConnection)");
        }
        this.connection = aConnection;
        this.configuration = aConfiguration;
    }

    @Override
    public String getName() {
        return this.configuration.getName();
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(Messages.IZE0100I_connected, this.configuration.getDescription());
    }

    @Override
    public Image getImage() {
        if (this.connection.isSecure()) {
            return ConnectionsImages.getImage("ACTIVE_SECURE_CONNECTION");
        }
        return ConnectionsImages.getImage("ACTIVE_CONNECTION");
    }

    @Override
    public String getMenuMessage() {
        return this.getMessage();
    }

    public String toString() {
        return "CONNECTED";
    }

    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public String getID() {
        return this.configuration.getId();
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.configuration;
    }
}

