/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.internal.views.ConnectionProviderDescriptorNode;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ConnectionsLabelDecorator
implements ILabelDecorator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String decorateText(String text, Object element) {
        if (element instanceof ConnectionProfile) {
            ConnectionProfile configuration = (ConnectionProfile)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(text);
            CredentialsConfiguration credentials = configuration.getCredentials();
            if (credentials != null) {
                buffer.append(" [");
                if (credentials != null) {
                    buffer.append(credentials.getName());
                }
                buffer.append("]");
                return buffer.toString();
            }
        } else {
            if (element instanceof IConnectionCategory) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(text);
                int totalNumberOfConnections = 0;
                IConnectionDescriptor[] iConnectionDescriptorArray = ((IConnectionCategory)element).getConnections();
                int n = iConnectionDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConnectionDescriptor aConnectionDescriptor = iConnectionDescriptorArray[n2];
                    totalNumberOfConnections += this.getNumberOfConnections(aConnectionDescriptor);
                    ++n2;
                }
                this.appendTotal(buffer, totalNumberOfConnections);
                return buffer.toString();
            }
            if (element instanceof IConnectionDescriptor) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(text);
                int numberOfConnectionsForDescriptor = this.getNumberOfConnections((IConnectionDescriptor)element);
                this.appendTotal(buffer, numberOfConnectionsForDescriptor);
                return buffer.toString();
            }
            if (element instanceof ConnectionProviderDescriptorNode) {
                ConnectionProviderDescriptorNode node = (ConnectionProviderDescriptorNode)element;
                StringBuffer buffer = new StringBuffer();
                buffer.append(text);
                this.appendTotal(buffer, node.getConfigurations().size());
                return buffer.toString();
            }
        }
        return text;
    }

    private void appendTotal(StringBuffer buffer, int numberOfConnections) {
        if (numberOfConnections > 0) {
            buffer.append(" (");
            buffer.append(String.valueOf(numberOfConnections));
            buffer.append(")");
        }
    }

    private int getNumberOfConnections(IConnectionDescriptor aConnectionDescriptor) {
        IConnectionManager connectionManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager();
        Map<IConnectionDescriptor, List<ConnectionProfile>> configurationsByDescriptor = connectionManager.getConnectionProfilesByDescriptor();
        List<ConnectionProfile> list = configurationsByDescriptor.get(aConnectionDescriptor);
        return list != null ? list.size() : 0;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }
}

