/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.IJVMProfile;
import com.ibm.cics.model.IPipeline;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.zos.core.ui.IHFSFileProvider;
import com.ibm.cics.zos.model.IJobDetails;
import com.ibm.cics.zos.model.JobDetails;
import org.eclipse.core.runtime.IAdapterFactory;

public class CICSToZOSAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object getAdapter(final Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IRegion && adapterType == IJobDetails.class) {
            IRegion aRegion = (IRegion)adaptableObject;
            if (aRegion != null) {
                String jobId = aRegion.getJobid().equals(ICICSAttributeConstants.UNSUPPORTED_STRING) ? null : aRegion.getJobid();
                String jobName = aRegion.getJobName();
                return new JobDetails(jobName, jobId, "*");
            }
        } else if (adapterType == IHFSFileProvider.class) {
            if (adaptableObject instanceof IPipeline) {
                return new IHFSFileProvider(){

                    public String getFilePath() {
                        return ((IPipeline)adaptableObject).getConfigurationFile();
                    }
                };
            }
            if (adaptableObject instanceof IJVMProfile) {
                return new IHFSFileProvider(){

                    public String getFilePath() {
                        return ((IJVMProfile)adaptableObject).getHfsname();
                    }
                };
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IJobDetails.class, IHFSFileProvider.class};
    }
}

