/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.ICICSAttributeHint;
import java.util.HashMap;
import java.util.Map;

public class CICSAttributeHint
implements ICICSAttributeHint {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private long[] range;
    private Map<String, Long> specialValues;
    private Integer maxLength;

    CICSAttributeHint() {
    }

    public static ICICSAttributeHint range(long min, long max) {
        CICSAttributeHint result = new CICSAttributeHint();
        result.range = new long[]{min, max};
        return result;
    }

    public static ICICSAttributeHint rangeAndSpecial(long min, long max, Map<String, Long> specialValues, Long ... unnamedSpecials) {
        if (unnamedSpecials != null && specialValues == null) {
            specialValues = new HashMap<String, Long>();
        }
        Long[] longArray = unnamedSpecials;
        int n = unnamedSpecials.length;
        int n2 = 0;
        while (n2 < n) {
            Long myLong = longArray[n2];
            specialValues.put(myLong.toString(), myLong);
            ++n2;
        }
        CICSAttributeHint result = new CICSAttributeHint();
        result.range = new long[]{min, max};
        result.specialValues = specialValues;
        return result;
    }

    public static ICICSAttributeHint maxLength(Integer maxLength) {
        CICSAttributeHint result = new CICSAttributeHint();
        result.maxLength = maxLength;
        return result;
    }

    @Override
    public boolean hasMaxLength() {
        return this.maxLength != null;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean hasNumericRange() {
        return this.range != null;
    }

    @Override
    public long[] getNumericRange() {
        return this.range;
    }

    @Override
    public boolean hasSpecialValues() {
        return this.getSpecialValues() != null && this.getSpecialValues().size() > 0;
    }

    @Override
    public Map<String, Long> getSpecialValues() {
        return this.specialValues;
    }
}

