/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.model.TransactionDefinitionType;
import com.ibm.cics.eclipse.common.AbstractContextManager;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.ICICSOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityListener;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class ConnectionContextManager
extends AbstractContextManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CANCREATE_CICSDEF_CTX_ID = "com.ibm.cics.explorer.cancreatecicsdef.context";
    public static final String CANCREATE_CPSMDEF_CTX_ID = "com.ibm.cics.explorer.cancreatecpsmdef.context";
    private static final String COM_IBM_CICS_EXPLORER_SYSTEMADMIN = "com.ibm.cics.explorer.systemadmin.activity";
    private boolean systemadminActivity = false;
    private ICPSM cpsm = null;
    private ConnectionServiceListener listener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event.getConnectionCategoryId().equals("com.ibm.cics.sm.connection")) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent && event.getConnectable() instanceof ICPSM) {
                    ConnectionContextManager.this.connected((ICPSM)event.getConnectable());
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    ConnectionContextManager.this.disconnected();
                }
            }
        }
    };
    private IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
    private IActivityManager activityManager = this.workbenchActivitySupport.getActivityManager();

    public ConnectionContextManager(IConnectionService connectionService) {
        debug.event("ConnectionContextManager()<init>", "");
        connectionService.addConnectionServiceListener(this.listener);
        IActivity activity = this.activityManager.getActivity(COM_IBM_CICS_EXPLORER_SYSTEMADMIN);
        if (activity != null) {
            activity.addActivityListener(new IActivityListener(){

                public void activityChanged(ActivityEvent activityEvent) {
                    IActivity activity = activityEvent.getActivity();
                    ConnectionContextManager.this.systemadminActivity = activity.isEnabled();
                    if (ConnectionContextManager.this.systemadminActivity && ConnectionContextManager.this.cpsm != null) {
                        ConnectionContextManager.this.connected(ConnectionContextManager.this.cpsm);
                    } else {
                        ConnectionContextManager.this.disconnected();
                    }
                }
            });
            this.systemadminActivity = activity.isEnabled();
        }
        this.disconnected();
    }

    public void dispose() {
        this.listener.makeStale();
    }

    void disconnected() {
        this.deactivate(CANCREATE_CICSDEF_CTX_ID);
        this.deactivate(CANCREATE_CPSMDEF_CTX_ID);
        this.cpsm = null;
    }

    void connected(ICPSM cpsm) {
        boolean canCreateCicsDef;
        this.cpsm = cpsm;
        boolean canCreateCpsmDef = cpsm.checkPermission(ICICSOperation.CREATE, (ICICSType)ResourceGroupDefinitionType.getInstance());
        if (canCreateCpsmDef && this.systemadminActivity) {
            this.activate(CANCREATE_CPSMDEF_CTX_ID);
        }
        if ((canCreateCicsDef = cpsm.checkPermission(ICICSOperation.CREATE, (ICICSType)TransactionDefinitionType.getInstance())) && this.systemadminActivity) {
            this.activate(CANCREATE_CICSDEF_CTX_ID);
        }
    }

    public boolean canCreateCPSMDefinition() {
        return ConnectionContextManager.isContextActive((String)CANCREATE_CPSMDEF_CTX_ID);
    }

    public boolean canCreateCICSDefinition() {
        return ConnectionContextManager.isContextActive((String)CANCREATE_CICSDEF_CTX_ID);
    }
}

