/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.AbstractOperationUIDelegate;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.core.ui.internal.cloud.AddNewRegionToRegionTypeExecutionDelegate;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IPlatform;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddNewRegionToRegionTypeUIDelegate<T>
extends AbstractOperationUIDelegate<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NAME_VALIDATION_REGEX = "[0-9a-zA-Z\\._#@-]+";
    private ICICSRegionGroupDefinition defaultRegionType;
    private final IPlatform selectedPlatform;
    private String specificRegionName;
    private String applid;
    private String sysid;
    private String description = null;
    private String primaryCMAS;
    private boolean isComplete = false;
    Label lblRegionTypeValue;
    Text regionText;
    Text applIDText;
    Text sysIDText;
    Text primaryCMASText;
    private boolean applidMatchesCCSYSDEF = true;
    private boolean regionUpdatingApplid = false;

    public AddNewRegionToRegionTypeUIDelegate(IPlatform platform, ICICSRegionGroupDefinition definition) {
        this.selectedPlatform = platform;
        this.defaultRegionType = definition;
    }

    public ILabelProvider getLabelProvider() {
        return new CICSObjectLabelProvider();
    }

    private void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public void createControls(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        Composite parentParentComposite = parent.getParent();
        GridData parentParentGridData = (GridData)parentParentComposite.getLayoutData();
        parentParentGridData.horizontalAlignment = 4;
        parentParentGridData.verticalAlignment = 4;
        parentParentGridData.grabExcessHorizontalSpace = true;
        parentParentGridData.grabExcessVerticalSpace = true;
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblTarget = new Label(content, 0);
        lblTarget.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblTarget.setText(NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_targetLabel, null));
        Composite labelComposite = new Composite(content, 0);
        labelComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        Label lblRegionTypeImage = new Label(labelComposite, 0);
        lblRegionTypeImage.setImage(UIPlugin.getTableImage(CICSRegionGroupDefinitionType.getInstance().getResourceTableName()));
        this.lblRegionTypeValue = new Label(labelComposite, 0);
        this.lblRegionTypeValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.lblRegionTypeValue.setText(this.defaultRegionType.getRegiontype());
        Label lblRegion = new Label(content, 0);
        lblRegion.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        lblRegion.setText(NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_regionLabel, null));
        this.regionText = TextInput.createText((Composite)content, (int)8, (Label)lblRegion);
        this.regionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        EnsureUppercaseListener.attach((Text)this.regionText);
        this.regionText.addModifyListener(this.getValidationListener());
        Label l = new Label(content, 0);
        l.setText(NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_applidLabel, null));
        this.applIDText = TextInput.createText((Composite)content, (int)8, (Label)l);
        EnsureUppercaseListener.attach((Text)this.applIDText);
        this.applIDText.addModifyListener(this.getValidationListener());
        l = new Label(content, 0);
        l.setText(NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_sysidLabel, null));
        this.sysIDText = TextInput.createText((Composite)content, (int)8, (Label)l);
        EnsureUppercaseListener.attach((Text)this.sysIDText);
        this.sysIDText.addModifyListener(this.getValidationListener());
        l = new Label(content, 0);
        l.setText(NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_primaryCMASLabel, null));
        this.primaryCMASText = TextInput.createText((Composite)content, (int)8, (Label)l);
        EnsureUppercaseListener.attach((Text)this.primaryCMASText);
        this.primaryCMASText.addModifyListener(this.getValidationListener());
    }

    private void updateControls(ModifyEvent modifyEvent) {
        this.possiblySetApplidFromCSYSDEF(modifyEvent, true);
        boolean errorHappens = false;
        RegionNameValidator regionNameValidator = new RegionNameValidator(this.regionText.getText());
        ApplidValidator applidValidator = new ApplidValidator(this.applIDText.getText());
        SysidValidator sysidValidator = new SysidValidator(this.sysIDText.getText());
        PrimaryCMASValidator primaryCMASValidator = new PrimaryCMASValidator(this.primaryCMASText.getText());
        if (this.checkValidation(primaryCMASValidator)) {
            this.primaryCMAS = primaryCMASValidator.getTextString();
        } else {
            errorHappens = true;
        }
        if (this.checkValidation(sysidValidator)) {
            this.sysid = sysidValidator.getTextString();
        } else {
            errorHappens = true;
        }
        if (this.checkValidation(applidValidator)) {
            this.applid = applidValidator.getTextString();
        } else {
            errorHappens = true;
        }
        if (this.checkValidation(regionNameValidator)) {
            this.specificRegionName = regionNameValidator.getTextString();
        } else {
            errorHappens = true;
        }
        this.setComplete(!errorHappens);
        this.stateChanged();
    }

    private void possiblySetApplidFromCSYSDEF(ModifyEvent modifyEvent, boolean csysdefValid) {
        if (!this.regionUpdatingApplid && modifyEvent != null && this.applIDText.equals(modifyEvent.getSource())) {
            this.applidMatchesCCSYSDEF = false;
        }
        if (modifyEvent != null && this.regionText.equals(modifyEvent.getSource()) && (this.applidMatchesCCSYSDEF || this.applIDText.getText().length() == 0)) {
            String csysdefName = this.regionText.getText();
            if (csysdefValid || csysdefName.length() == 0) {
                this.regionUpdatingApplid = true;
                this.applIDText.setText(csysdefName);
                this.regionUpdatingApplid = false;
                this.applidMatchesCCSYSDEF = true;
            }
        }
    }

    private boolean checkValidation(Validator validator) {
        IStatus validateStatus = validator.validate();
        if (!validateStatus.isOK()) {
            this.error(validateStatus.getMessage());
            return false;
        }
        return true;
    }

    public IOperationExecutionDelegate<? super T> getExecutionDelegate() {
        return new AddNewRegionToRegionTypeExecutionDelegate(this.selectedPlatform, this.defaultRegionType, this.specificRegionName, this.applid, this.sysid, this.primaryCMAS, this.description);
    }

    public String getOperationName() {
        return NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_addRegionToRegionType, null);
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    private ModifyListener getValidationListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddNewRegionToRegionTypeUIDelegate.this.updateControls(e);
            }
        };
    }

    private class ApplidValidator
    extends Validator {
        public ApplidValidator(String applid) {
            this.text = applid;
        }

        @Override
        public IStatus validate() {
            if (this.text.trim().equals("")) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_pleaseSpecifyApplid, null));
            }
            if (this.text.length() > 8) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_applidExceedLength, null));
            }
            if (!this.text.matches(AddNewRegionToRegionTypeUIDelegate.NAME_VALIDATION_REGEX)) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_applidInvalidCharacters, null));
            }
            return ValidationStatus.ok();
        }
    }

    static class PlatformComboLabelProvider
    extends LabelProvider {
        PlatformComboLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IPlatform) {
                return UIPlugin.getTableImage(PlatformType.getInstance().getResourceTableName());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IPlatform) {
                return ((IPlatform)element).getName();
            }
            return element.toString();
        }
    }

    private class PrimaryCMASValidator
    extends Validator {
        public PrimaryCMASValidator(String primaryCMAS) {
            this.text = primaryCMAS;
        }

        @Override
        public IStatus validate() {
            if (this.text.length() > 8) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_primaryCMASExceedLength, null));
            }
            if (this.text.length() > 0 && !this.text.matches(AddNewRegionToRegionTypeUIDelegate.NAME_VALIDATION_REGEX)) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_primaryCMASInvalidCharacters, null));
            }
            return ValidationStatus.ok();
        }
    }

    private class RegionNameValidator
    extends Validator {
        public RegionNameValidator(String regionname) {
            this.text = regionname;
        }

        @Override
        public IStatus validate() {
            if (this.text.trim().equals("")) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_pleaseSpecifyRegion, null));
            }
            if (this.text.length() > 8) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_exceedLength, null));
            }
            if (!this.text.matches(AddNewRegionToRegionTypeUIDelegate.NAME_VALIDATION_REGEX)) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_invalidCharacters, null));
            }
            return ValidationStatus.ok();
        }
    }

    private class SysidValidator
    extends Validator {
        public SysidValidator(String sysid) {
            this.text = sysid;
        }

        @Override
        public IStatus validate() {
            if (this.text.trim().equals("")) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_pleaseSpecifySysid, null));
            }
            if (this.text.length() > 4) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_sysidExceedLength, null));
            }
            if (!this.text.matches(AddNewRegionToRegionTypeUIDelegate.NAME_VALIDATION_REGEX)) {
                return ValidationStatus.error((String)NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeUIDelegate_sysidInvalidCharacters, null));
            }
            return ValidationStatus.ok();
        }
    }

    private abstract class Validator {
        protected String text;

        private Validator() {
        }

        public abstract IStatus validate();

        public String getTextString() {
            return this.text;
        }
    }
}

