/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.IDescriptionProvider;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class AttributePropertyDescriptor
implements IAttributePropertyDescriptor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IAttribute attribute;
    private String id;
    private boolean mutable;
    private String helpContextId;
    private final IDescriptionProvider descriptionProvider;
    private final String DISPLAY_NAME_KEY;
    private final String DESCRIPTION_KEY;
    private final String CATEGORY_KEY;
    private final ILabelProvider labelProvider;

    public AttributePropertyDescriptor(IType aType, IAttribute anAttribute, String propertyPrefix, boolean mutable, IDescriptionProvider descriptionProvider, ILabelProvider labelProvider) {
        this.mutable = mutable;
        this.descriptionProvider = descriptionProvider;
        this.labelProvider = labelProvider;
        this.id = anAttribute.getPropertyId();
        this.attribute = anAttribute;
        this.helpContextId = String.valueOf(descriptionProvider.getHelpContextIdPrefix()) + "property_" + aType.getClass().getCanonicalName() + "_" + anAttribute.getPropertyId();
        this.DISPLAY_NAME_KEY = "displayName_" + propertyPrefix + "." + this.attribute.getPropertyId();
        this.DESCRIPTION_KEY = "description_" + propertyPrefix + "." + this.attribute.getPropertyId();
        this.CATEGORY_KEY = "category_" + propertyPrefix + this.attribute.getCategoryId();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return null;
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this.equals(anotherProperty);
    }

    public boolean equals(Object o) {
        if (o instanceof AttributePropertyDescriptor) {
            return this.equals((AttributePropertyDescriptor)o);
        }
        return super.equals(o);
    }

    private boolean equals(AttributePropertyDescriptor other) {
        return this.attribute.equals(other.attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.attribute + "]";
    }

    @Override
    public IAttribute getAttribute() {
        return this.attribute;
    }

    public String getCategory() {
        return this.descriptionProvider.getString(this.CATEGORY_KEY);
    }

    public String getDescription() {
        return this.descriptionProvider.getString(this.DESCRIPTION_KEY);
    }

    public String getDisplayName() {
        return this.descriptionProvider.getString(this.DISPLAY_NAME_KEY);
    }

    public Object getHelpContextIds() {
        return this.helpContextId;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }
}

