/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AttributePropertyHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AttributePropertyHelper.class.getPackage().getName());
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    protected IType<?> type;
    protected IAttributePropertyDescriptor[] descriptors = new IAttributePropertyDescriptor[0];
    protected Map<Object, IAttributePropertyDescriptor> descriptorMap = new HashMap<Object, IAttributePropertyDescriptor>();

    protected AttributePropertyHelper(IType<?> aType, Class<?> accessorsProviderInterface) {
        this.type = aType;
        Method[] methods = accessorsProviderInterface.getMethods();
        HashMap<String, Method> getMethodsMap = new HashMap<String, Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                getMethodsMap.put(method.getName(), method);
            }
            ++n2;
        }
        methodArray = this.type.attributes();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            String simpleClassName;
            IAttributePropertyDescriptor descriptor;
            Method attribute = methodArray[n2];
            String expectedGetterName = AttributePropertyHelper.getGetMethodNameFromId(attribute.getPropertyId());
            Method method = (Method)getMethodsMap.get(expectedGetterName);
            if (method != null && this.isMethodAttributeAccessor(method, (IAttribute<?>)attribute) && (descriptor = this.createPropertyDescriptor(this.type, (IAttribute<?>)attribute, simpleClassName = this.simpleClassName(method.getDeclaringClass()), this.existsAttributeMutator(accessorsProviderInterface, (IAttribute<?>)attribute))) != null) {
                this.descriptorMap.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
        this.descriptors = new IAttributePropertyDescriptor[this.descriptorMap.size()];
        this.descriptorMap.values().toArray(this.descriptors);
    }

    public IType<?> getType() {
        return this.type;
    }

    public IAttributePropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public IAttributePropertyDescriptor getPropertyDescriptor(Object id) {
        return this.descriptorMap.get(id);
    }

    protected abstract IAttributePropertyDescriptor createPropertyDescriptor(IType<?> var1, IAttribute<?> var2, String var3, boolean var4);

    public static Object getPropertyValue(Object object, String id) {
        String getMethodName = AttributePropertyHelper.getGetMethodNameFromId(id);
        try {
            Method method = object.getClass().getMethod(getMethodName, EMPTY_CLASS_ARRAY);
            return method.invoke(object, EMPTY_OBJ_ARRAY);
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public static void setPropertyValue(Object object, String id, Object value) {
        String setMethodName = AttributePropertyHelper.getSetMethodNameFromId(id);
        Class<?> setterParameterType = AttributePropertyHelper.getSetMethodParameterType(id, object.getClass());
        try {
            Object[] args = new Object[]{value};
            Method method = object.getClass().getMethod(setMethodName, setterParameterType);
            method.invoke(object, args);
        }
        catch (Exception ex) {
            Debug.error((Logger)logger, (String)AttributePropertyHelper.class.getName(), (String)"setPropertyValue", (Throwable)ex);
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    private boolean isMethodAttributeAccessor(Method method, IAttribute<?> attribute) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && attribute.getType().isAssignableFrom(method.getReturnType());
    }

    private boolean existsAttributeMutator(Class<?> interfaceType, IAttribute<?> attribute) {
        boolean result = false;
        String methodName = AttributePropertyHelper.getSetMethodNameFromId(attribute.getPropertyId());
        Class[] parameterTypes = new Class[]{attribute.getType()};
        try {
            interfaceType.getMethod(methodName, parameterTypes);
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private static Class<?> getSetMethodParameterType(String id, Class<?> clazz) {
        String getMethodName = AttributePropertyHelper.getGetMethodNameFromId(id);
        try {
            Method method = clazz.getMethod(getMethodName, EMPTY_CLASS_ARRAY);
            return method.getReturnType();
        }
        catch (Exception ex) {
            Debug.error((Logger)logger, (String)AttributePropertyHelper.class.getName(), (String)"getSetMethodParameterType", (Throwable)ex);
            throw new UnsupportedOperationException(ex.toString());
        }
    }

    private String simpleClassName(Class<?> type) {
        String className = type.getName();
        int index = className.lastIndexOf(46);
        String simpleClassName = className.substring(index + 1);
        return simpleClassName;
    }

    private static String getSetMethodNameFromId(String id) {
        return AttributePropertyHelper.getMethodNameFromId(id, "set");
    }

    private static String getGetMethodNameFromId(String id) {
        return AttributePropertyHelper.getMethodNameFromId(id, "get");
    }

    private static String getMethodNameFromId(String id, String prefix) {
        return String.valueOf(prefix) + id.substring(0, 1).toUpperCase(Locale.ENGLISH) + id.substring(1);
    }
}

