/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.IllegalCICSAttributeException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CICSAttributeLabelProvider
extends LabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String UNSUPPORTED_TEXT = "N/A";
    protected static final String UNEXPECTED_TEXT = "?";
    private static Logger logger = Logger.getLogger("com.ibm.cics.core.model");
    private ThreadLocal<DateFormat> dateTimeFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return SimpleDateFormat.getDateTimeInstance();
        }
    };
    protected ICICSAttribute<?> cicsAttribute;

    public CICSAttributeLabelProvider(ICICSAttribute<?> cicsAttribute) {
        this.cicsAttribute = cicsAttribute;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element != null) {
            if (this.cicsAttribute.getUnsupportedValue() == element) {
                return UNSUPPORTED_TEXT;
            }
            if (this.cicsAttribute.getUnexpectedValue() == element) {
                return UNEXPECTED_TEXT;
            }
            if (element instanceof Date) {
                if (element == ICICSAttributeConstants.UNSPECIFIED_DATE) {
                    return "";
                }
                return this.dateTimeFormat.get().format((Date)element);
            }
            if (String.class.isAssignableFrom(this.cicsAttribute.getType())) {
                if (element instanceof String) {
                    return (String)element;
                }
                logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "getText", "element " + element + " was not a String");
                return null;
            }
            if (this.cicsAttribute.getType().isAssignableFrom(element.getClass())) {
                try {
                    return this.cicsAttribute.internalToExternal(element);
                }
                catch (IllegalCICSAttributeException ex) {
                    logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "getText", "internal to external conversion failed  for element: " + element, ex);
                    return null;
                }
            }
            logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "getText", "element " + element + " could not be cast to attribute type: " + this.cicsAttribute.getType());
            return null;
        }
        logger.logp(Level.WARNING, ((Object)((Object)this)).getClass().getName(), "getText", "element was null");
        return null;
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }
}

