/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.AttributePropertyHelper;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ITypedObjectPropertySource;
import com.ibm.cics.model.meta.IType;
import com.ibm.cics.model.meta.ITypedObject;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class TypedObjectPropertySource
implements ITypedObjectPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ITypedObject object;
    protected AttributePropertyHelper helper;

    public TypedObjectPropertySource(ITypedObject typedObject) {
        this(typedObject, typedObject.getObjectType().getInterfaceType());
    }

    protected TypedObjectPropertySource(ITypedObject cicsObject, Class<?> interfaceType) {
        this.helper = this.createHelper(cicsObject.getObjectType(), interfaceType);
        this.object = cicsObject;
    }

    protected abstract AttributePropertyHelper createHelper(IType<?> var1, Class<?> var2);

    public Object getEditableValue() {
        return null;
    }

    @Override
    public IAttributePropertyDescriptor[] getPropertyDescriptors() {
        return this.helper.getPropertyDescriptors();
    }

    public Object getPropertyValue(Object id) {
        return AttributePropertyHelper.getPropertyValue(this.object, (String)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
        throw new UnsupportedOperationException(id.toString());
    }

    public void setPropertyValue(Object id, Object value) {
        this.setPropertyValueImpl(id, value);
    }

    protected void setPropertyValueImpl(Object id, Object value) {
        AttributePropertyHelper.setPropertyValue(this.getObject(), (String)id, value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.object + "]";
    }

    public IPropertyDescriptor getPropertyDescriptor(Object id) {
        return this.helper.getPropertyDescriptor(id);
    }

    protected Object getObject() {
        return this.object;
    }

    public IType<?> getObjectType() {
        return this.object.getObjectType();
    }
}

