/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.PreferenceInvocationHandler;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.viewers.AbstractResourcesViewContentProvider;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.ResourcesView;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public abstract class AbstractResourcesView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    IContext context;
    protected IConnectable cpsm;
    protected TableViewer tableViewer;
    protected TableColumnLayout layout;
    protected AbstractResourcesViewContentProvider contentProvider;
    protected List<IPropertyDescriptor> filterProperties = new ArrayList<IPropertyDescriptor>();
    protected Map<IPropertyDescriptor, String> filterPropertyValues;
    protected IPartListener2 partListener;
    protected ISelectionListener selectionListener;
    protected boolean visible;
    protected boolean dirty;
    protected IAction runFilterAction;
    protected IAction clearFilterAction;
    protected IHandler refreshCommandHandler;
    private Action refreshAction;
    private IAction resetColumnsAction;
    private IAction resetWidthsAction;
    private IAction customizeColumnsActions;
    private Menu popupMenu;
    protected static final int COLUMN_WEIGHT = 1;
    protected static final int COLUMN_MIN_WIDTH = 75;
    public static final Integer NO_WIDTH_SPECIFIED = new Integer(-1);
    public static final String NO_FILTER_PROPERTIES = "NONE";
    protected static final String CCID = "CustomColumnActionId";
    private static final Logger logger = Logger.getLogger(AbstractResourcesView.class.getPackage().getName());
    private static final com.ibm.cics.common.util.Debug debug = new com.ibm.cics.common.util.Debug(AbstractResourcesView.class);
    protected List<IContributionItem> filterToolBarContributionItems = new LinkedList<IContributionItem>();
    protected Map<ICICSObjectPropertyDescriptor, IPropertyValueEditor> filterEditors = new HashMap<ICICSObjectPropertyDescriptor, IPropertyValueEditor>();
    private ResourcesViewConnectionServiceListener connectionServiceListener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        Debug.enter((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"init", (Object)((Object)this), (Object)site);
        Debug.exit((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"init");
    }

    protected void addColumn(IPropertyDescriptor descriptor) {
        this.addColumn(this.tableViewer.getTable(), (String)descriptor.getId(), descriptor);
    }

    protected void removeColumn(IPropertyDescriptor descriptor) {
        TableColumn[] columns;
        TableColumn[] tableColumnArray = columns = this.tableViewer.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            IPropertyDescriptor propertyDescriptor = (IPropertyDescriptor)column.getData(IPropertyDescriptor.class.getName());
            if (propertyDescriptor == descriptor) {
                column.dispose();
            }
            ++n2;
        }
    }

    private void addColumn(Table table, String name, IPropertyDescriptor descriptor) {
        this.addColumn(table, name, descriptor, (ColumnLayoutData)new ColumnWeightData(1, 75));
    }

    private TableColumn addColumn(Table table, String name, IPropertyDescriptor descriptor, ColumnLayoutData layoutData) {
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setData((Object)name);
        tableColumn.setData(IPropertyDescriptor.class.getName(), (Object)descriptor);
        tableColumn.setText(descriptor.getDisplayName());
        tableColumn.setToolTipText(descriptor.getDescription());
        this.layout.setColumnData((Widget)tableColumn, layoutData);
        tableColumn.setAlignment(16384);
        tableColumn.setMoveable(true);
        return tableColumn;
    }

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"createPartControl", (Object)((Object)this), (Object)parent);
        this.setContentDescription(Messages.getString("ResourcesView.status.disconnected", new Object[0]));
        this.layout = new TableColumnLayout();
        parent.setLayout((Layout)this.layout);
        this.tableViewer = new TableViewer(parent, 268501762);
        this.addColumns();
        this.contentProvider = this.createContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        ITableLabelProvider labelProvider = this.createLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.createPopupMenu();
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillActionBar(this.getViewSite().getActionBars());
        this.addListeners((StructuredViewer)this.tableViewer);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.refresh", this.refreshCommandHandler);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        Debug.exit((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"createPartControl");
    }

    public void setContentDescription(String description) {
        super.setContentDescription(description);
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void exception(IConnectable cpsm, Exception ex) {
    }

    public boolean disconnecting(IConnectable cpsm) {
        return false;
    }

    public void disconnected(IConnectable cpms) {
        Debug.enter((Logger)logger, (String)ResourcesView.class.getName(), (String)"disconnected", (Object)((Object)this), (Object)this.cpsm);
        this.runFilterAction.setEnabled(false);
        this.clearFilterAction.setEnabled(false);
        this.saveColumns();
        this.tableViewer.setInput(null);
        this.cpsm = null;
        this.context = null;
        this.setContentDescription(Messages.getString("ResourcesView.status.disconnected", new Object[0]));
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (this == activePart) {
            this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        Debug.exit((Logger)logger, (String)ResourcesView.class.getName(), (String)"disconnected");
    }

    public void connecting(IConnectable cpsm) {
    }

    protected void addListeners(StructuredViewer viewer) {
        Debug.enter((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"addListeners", (Object)((Object)this), (Object)viewer);
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractResourcesView.this.saveColumns();
            }
        });
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    Debug.event((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"partActivated", (Object)((Object)AbstractResourcesView.this), (Object)partRef.getPartName());
                    AbstractResourcesView.this.maybeSetInput();
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this && Debug.DEBUG_SELECTION) {
                    debug.event("partBroughtToTop()", "partRef=" + partRef.getPartName());
                }
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    if (Debug.DEBUG_SELECTION) {
                        debug.event("partClosed()", "partRef=" + partRef.getPartName());
                    }
                    AbstractResourcesView.this.closed();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    debug.event("partDeactivated", (Object)AbstractResourcesView.this, (Object)partRef.getPartName());
                    AbstractResourcesView.this.clearStatusMessage();
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    debug.event("partHidden", (Object)AbstractResourcesView.this, (Object)partRef.getPartName());
                    AbstractResourcesView.this.visible = false;
                }
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this && Debug.DEBUG_SELECTION) {
                    debug.event("partInputChanged()", "partRef=" + partRef.getPartName());
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    if (Debug.DEBUG_SELECTION) {
                        debug.event("partOpened()", "partRef=" + partRef.getPartName());
                    }
                    AbstractResourcesView.this.opened();
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getPart(false) == AbstractResourcesView.this) {
                    Debug.event((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"partVisible", (Object)((Object)AbstractResourcesView.this), (Object)partRef.getPartName());
                    AbstractResourcesView.this.visible = true;
                    AbstractResourcesView.this.maybeSetInput();
                }
            }
        };
        this.getSite().getPage().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    int tableSelectionSize;
                    int viewerSelectionSize = ((IStructuredSelection)selection).size();
                    if (viewerSelectionSize < (tableSelectionSize = AbstractResourcesView.this.tableViewer.getTable().getSelection().length)) {
                        Debug.event((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"selectionChanged", (Object)this, (Object)viewerSelectionSize, (Object)tableSelectionSize);
                        AbstractResourcesView.this.tableViewer.getControl().setMenu(null);
                        String message = Messages.getString("ResourcesView.popupmenu.disabled", viewerSelectionSize, tableSelectionSize);
                        AbstractResourcesView.this.setWarningStatusMessage(message);
                    } else {
                        Debug.event((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"selectionChanged", (Object)this, (Object)viewerSelectionSize, (Object)AbstractResourcesView.this.popupMenu);
                        AbstractResourcesView.this.tableViewer.getControl().setMenu(AbstractResourcesView.this.popupMenu);
                        AbstractResourcesView.this.clearStatusMessage();
                    }
                }
            }
        });
        Debug.exit((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"addListeners");
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.refreshAction = new Action(Messages.getString("ResourcesView.refreshAction.text", new Object[0])){

            public void run() {
                AbstractResourcesView.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(Messages.getString("ResourcesView.refreshAction.tooltip", new Object[0]));
        this.refreshAction.setImageDescriptor(UIPlugin.IMGD_REFRESH);
        this.refreshCommandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                AbstractResourcesView.this.refresh();
                return null;
            }
        };
        this.resetColumnsAction = new Action(Messages.getString("ResourcesView.resetColumnsAction.text", new Object[0])){

            public void run() {
                AbstractResourcesView.this.resetColumns();
            }
        };
        this.customizeColumnsActions = new Action(Messages.getString("ResourcesView.customizeColumnsAction.text", new Object[0])){

            public void run() {
                AbstractResourcesView.this.customizeColumnsActions();
            }
        };
        this.customizeColumnsActions.setId(CCID);
        this.resetWidthsAction = new Action(Messages.getString("ResourcesView.equalizeColumnWidthsAction.text", new Object[0])){

            public void run() {
                TableColumn[] tableColumnArray = AbstractResourcesView.this.tableViewer.getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    AbstractResourcesView.this.layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, 75));
                    ++n2;
                }
                AbstractResourcesView.this.tableViewer.getTable().getParent().layout();
            }
        };
    }

    protected void fillActionBar(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        this.fillMenu(menu);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
    }

    protected void fillMenu(IMenuManager menu) {
        menu.add((IAction)this.refreshAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.resetColumnsAction);
        menu.add(this.resetWidthsAction);
        menu.add(this.customizeColumnsActions);
        menu.add((IContributionItem)new Separator());
        MenuManager columnsMenu = new MenuManager(Messages.getString("ResourcesView.filterMenu.text", new Object[0]));
        columnsMenu.add((IAction)new Action(){});
        columnsMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                AbstractResourcesView.this.fillFilterMenu(manager);
            }
        });
        menu.add((IContributionItem)columnsMenu);
    }

    protected void accept(ITableColumnVisitor visitor) {
        debug.enter("accept", (Object)this, (Object)visitor);
        Table table = this.tableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int[] columnOrder = table.getColumnOrder();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[columnOrder[i]];
            visitor.visit(column);
            ++i;
        }
        debug.exit("accept");
    }

    protected IContext getFilteredContext() {
        final Properties attributes = new Properties();
        for (ICICSObjectPropertyDescriptor descriptor : this.filterEditors.keySet()) {
            IPropertyValueEditor editor = this.filterEditors.get(descriptor);
            String value = editor.getValue();
            if (value == null || value.trim().length() <= 0) continue;
            ICICSAttribute<?> attribute = descriptor.getAttribute();
            attributes.put(attribute.getCicsName(), value);
        }
        debug.event("run", (Object)attributes);
        if (!attributes.isEmpty()) {
            return new AbstractFilteredContext(this.context){

                public String getAttributeValue(String attributeName) {
                    return attributes.getProperty(attributeName);
                }

                public Set getAttributeNames() {
                    return attributes.keySet();
                }
            };
        }
        return this.context;
    }

    protected void fillToolBar(final IToolBarManager toolBar) {
        toolBar.add((IContributionItem)new Separator("refresh"));
        toolBar.appendToGroup("refresh", (IAction)this.refreshAction);
        toolBar.add((IContributionItem)new Separator("additions"));
        Separator filterGroup = new Separator("filter");
        toolBar.add((IContributionItem)filterGroup);
        this.addFilterToolBarContributions(toolBar);
        GroupMarker filterActionsGroup = new GroupMarker("filterActions");
        toolBar.add((IContributionItem)filterActionsGroup);
        ((ToolBarManager)toolBar).getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String id;
                if (e.childID > -1 && (id = ((ToolBarManager)toolBar).getItems()[e.childID].getId()).equals("refresh")) {
                    e.result = String.valueOf(AbstractResourcesView.this.getContentDescription()) + Messages.getString("ResourcesView.refreshAction.tooltip", new Object[0]);
                }
            }
        });
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 1) {
                    int i = 0;
                    while (i < ((ToolBarManager)toolBar).getItems().length) {
                        IContributionItem tbItem = ((ToolBarManager)toolBar).getItems()[i];
                        if (tbItem.getId().equals("refresh")) {
                            ((ToolBarManager)toolBar).getControl().getAccessible().setFocus(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.runFilterAction = new Action(){

            public void run() {
                AbstractResourcesView.this.runFilterAction();
            }

            public String toString() {
                return "IAction[runFilterAction]";
            }
        };
        this.runFilterAction.setEnabled(false);
        this.runFilterAction.setToolTipText(Messages.getString("ResourcesView.runFilterAction.tooltip", new Object[0]));
        this.runFilterAction.setImageDescriptor(UIPlugin.getImageDescriptor("icons/full/elcl16/run.gif"));
        toolBar.appendToGroup("filterActions", this.runFilterAction);
        this.clearFilterAction = new Action(){

            public void run() {
                AbstractResourcesView.this.clearFilterAction();
            }

            public String toString() {
                return "IAction[clearFilterAction]";
            }
        };
        this.clearFilterAction.setEnabled(false);
        this.clearFilterAction.setToolTipText(Messages.getString("ResourcesView.clearFilterAction.tooltip", new Object[0]));
        this.clearFilterAction.setImageDescriptor(UIPlugin.getImageDescriptor("icons/clear_filter.gif"));
        toolBar.appendToGroup("filterActions", this.clearFilterAction);
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager(){

            protected void update(boolean force, boolean recursive) {
                AbstractResourcesView.this.menuAboutToUpdate((IMenuManager)this);
                super.update(force, recursive);
            }
        };
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AbstractResourcesView.this.menuAboutToShow(manager);
            }
        });
        this.popupMenu = menuMgr.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(this.popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    protected void menuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("open"));
        manager.add((IContributionItem)new Separator("actions"));
        manager.add((IContributionItem)new Separator("commonActions"));
        manager.add((IContributionItem)new Separator("enableActions"));
        manager.add((IContributionItem)new Separator("availableActions"));
        manager.add((IContributionItem)new Separator("discardAction"));
        manager.add((IContributionItem)new Separator("clipboard"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void menuAboutToUpdate(IMenuManager menuManager) {
    }

    protected void opened() {
        this.connectionServiceListener = new ResourcesViewConnectionServiceListener();
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener((ConnectionServiceListener)this.connectionServiceListener);
    }

    protected void closed() {
        this.connectionServiceListener.makeStale();
        this.removeListeners();
    }

    protected void schedule(Job job) {
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
    }

    protected void updateViewerColumnsAndData() {
        Debug.enter((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"updateViewer", (Object)((Object)this));
        this.saveColumns();
        this.addColumns();
        this.updateViewerFilterAndData();
        Debug.exit((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"updateViewer");
    }

    protected void updateViewerFilterAndData() {
        this.dirty = true;
        this.updateToolBar();
        this.maybeSetInput();
    }

    protected void clearStatusMessage() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(null);
        actionBars.getStatusLineManager().setErrorMessage(null);
        actionBars.updateActionBars();
    }

    protected void setStatusMessage(String message) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(message);
        actionBars.updateActionBars();
    }

    protected void setWarningStatusMessage(String message) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(UIPlugin.getImage(UIPlugin.IMGD_WARNING), message);
        actionBars.updateActionBars();
    }

    public void dispose() {
        Debug.event((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"dispose", (Object)((Object)this));
        super.dispose();
    }

    protected String getScope() {
        if (this.context instanceof IScopedContext) {
            return ((IScopedContext)this.context).getScope();
        }
        if (this.context instanceof IDefinitionContext) {
            return ((IDefinitionContext)this.context).getResourceGroup();
        }
        return this.context.getContext();
    }

    protected void contextChanged() {
        this.updateViewerFilterAndData();
    }

    protected void refresh() {
        Debug.enter((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"refresh", (Object)((Object)this));
        this.contentProvider.refresh();
        Debug.exit((Logger)logger, (String)AbstractResourcesView.class.getName(), (String)"refresh");
    }

    protected void updateToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager manager = actionBars.getToolBarManager();
        this.addFilterToolBarContributions(manager);
        manager.update(true);
    }

    protected void addFilterProperty(IPropertyDescriptor descriptor) {
        this.filterProperties.add(descriptor);
        this.filterPropertyValues.put(descriptor, "");
    }

    protected void removeFilterProperty(IPropertyDescriptor descriptor) {
        this.filterProperties.remove(descriptor);
    }

    protected abstract AbstractResourcesViewContentProvider createContentProvider();

    protected abstract ITableLabelProvider createLabelProvider();

    protected abstract void addColumns();

    protected abstract void saveColumns();

    protected IPreferenceStore getPreferenceStore() {
        IConnection connection;
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        if (this.cpsm != null && (connection = this.cpsm.getConnection()) instanceof IPluginContribution) {
            String pluginId = ((IPluginContribution)connection).getPluginId();
            PreferenceInvocationHandler handler = new PreferenceInvocationHandler(pluginId, store);
            store = (IPreferenceStore)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IPreferenceStore.class}, (InvocationHandler)handler);
        }
        return store;
    }

    protected abstract String getHelpContextId();

    protected abstract void fillFilterMenu(IMenuManager var1);

    protected abstract void saveFilterProperties();

    protected void removeListeners() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            activeWorkbenchWindow.getPartService().removePartListener(this.partListener);
            activeWorkbenchWindow.getSelectionService().removeSelectionListener(this.selectionListener);
        }
    }

    protected void maybeSetInput() {
        Object oldInput;
        if (this.cpsm != null && this.context != null && this.visible && ((oldInput = this.tableViewer.getInput()) == null || this.dirty)) {
            Debug.event((Logger)logger, (String)ResourcesView.class.getName(), (String)"maybeSetInput", (Object)((Object)this));
            this.clearStatusMessage();
            this.setInput();
            this.dirty = false;
            this.runFilterAction.setEnabled(true);
            this.clearFilterAction.setEnabled(true);
        }
    }

    protected void setInput() {
    }

    protected abstract void customizeColumnsActions();

    protected abstract void runFilterAction();

    protected abstract void clearFilterAction();

    protected abstract void addFilterToolBarContributions(IToolBarManager var1);

    protected abstract void resetColumns();

    void refreshTableLayout() {
        this.tableViewer.getTable().getParent().layout();
        this.tableViewer.refresh();
    }

    public static LinkedHashMap<String, Integer> getColumns(String columnNames, String columnWidths) {
        LinkedHashMap<String, Integer> columns = new LinkedHashMap<String, Integer>();
        String[] names = columnNames.split(",");
        String[] widths = columnWidths.split(",");
        int i = 0;
        while (i < names.length) {
            Integer width;
            if (i < widths.length) {
                try {
                    width = Integer.parseInt(widths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    width = NO_WIDTH_SPECIFIED;
                }
            } else {
                width = NO_WIDTH_SPECIFIED;
            }
            columns.put(names[i], width);
            ++i;
        }
        return columns;
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.sm.connection";
        }
        return super.getPartProperty(key);
    }

    protected void connected(IConnectable connectable) {
    }

    protected class FilterPropertySelectionAction
    extends Action {
        private IPropertyDescriptor descriptor;

        public FilterPropertySelectionAction(IPropertyDescriptor propertyDescriptor) {
            super(propertyDescriptor.getDisplayName(), 2);
            this.descriptor = propertyDescriptor;
        }

        public void run() {
            debug.enter("run", (Object)this, (Object)this.isChecked(), (Object)this.descriptor);
            boolean shouldSetInput = false;
            if (this.isChecked()) {
                AbstractResourcesView.this.addFilterProperty(this.descriptor);
            } else {
                AbstractResourcesView.this.removeFilterProperty(this.descriptor);
                shouldSetInput = AbstractResourcesView.this.cpsm != null;
            }
            AbstractResourcesView.this.saveFilterProperties();
            AbstractResourcesView.this.updateToolBar();
            if (shouldSetInput) {
                AbstractResourcesView.this.setInput();
            }
            debug.exit("run");
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + "[" + this.descriptor + ", " + this.isChecked() + "]";
        }
    }

    protected static interface IPropertyValueEditor {
        public String getValue();

        public void setValue(String var1);
    }

    private static interface ITableColumnVisitor {
        public void visit(TableColumn var1);
    }

    private class ResourcesViewConnectionServiceListener
    extends ConnectionServiceListener {
        private ResourcesViewConnectionServiceListener() {
        }

        public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
            if ("com.ibm.cics.sm.connection".equals(event.getConnectionCategoryId())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                            AbstractResourcesView.this.connected(event.getConnectable());
                        } else if (event instanceof ConnectionServiceListener.ConnectingEvent) {
                            AbstractResourcesView.this.connecting(event.getConnectable());
                        } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                            AbstractResourcesView.this.disconnecting(event.getConnectable());
                        } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                            AbstractResourcesView.this.disconnected(event.getConnectable());
                        } else if (event instanceof ConnectionServiceListener.ExceptionEvent) {
                            AbstractResourcesView.this.exception(event.getConnectable(), ((ConnectionServiceListener.ExceptionEvent)event).getException());
                        }
                    }
                });
            }
        }
    }
}

