/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import com.ibm.cics.sm.comm.context.ISystemParameterContext;
import com.ibm.cics.sm.comm.context.IWorkloadContext;
import com.ibm.cics.sm.comm.context.OrderedContext;
import com.ibm.cics.sm.comm.sm.IModelNames;
import com.ibm.cics.sm.comm.sm.SMConnectionException;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.SMCICSConnection;
import com.ibm.cics.sm.comm.sm.internal.VSE51ConnectionBehaviour;
import com.ibm.cics.sm.comm.sm.internal.VSE61ConnectionBehaviour;
import com.ibm.cics.sm.comm.sm.internal.VSEConnectionBehaviour;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SMVSEConnection
extends SMCICSConnection
implements ISystemManagerConnection2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SMVSEConnection.class);
    protected static final String VSE_111_EYU_CICSREL = "V111";
    protected static final String VSE_420_EYU_CICSREL = "V420";
    protected static final String CICS_TS_41_EYU_CICSREL = "040100";
    protected static final String CICS_TS_42_EYU_CICSREL = "040200";
    protected VSEConnectionBehaviour vseConnectionBehaviour = new VSEConnectionBehaviour();

    @Override
    protected String buildGETRequest(String resourceType, IContext context) throws UnsupportedEncodingException, TypeNotFoundException {
        String request;
        debug.enter("buildGETRequest", (Object)this, (Object)resourceType, (Object)context);
        if (context.getContext() == null) {
            request = "//";
        } else {
            IScopedContext scopedContext;
            String criteria;
            request = "";
            IContext parentContext = context;
            if (context instanceof IFilteredContext) {
                IFilteredContext filteredContext = (IFilteredContext)parentContext;
                criteria = this.getCriteriaFromFilteredContext(filteredContext);
                if (criteria.length() > 0) {
                    request = String.valueOf(request) + "?CRITERIA=(" + criteria + ")";
                }
                parentContext = filteredContext.getParentContext();
            } else if (context instanceof ICompoundFilteredContext) {
                ICompoundFilteredContext compoundFilteredContext = (ICompoundFilteredContext)parentContext;
                criteria = this.getCriteriaFromCompoundFilteredContext(compoundFilteredContext);
                if (criteria.length() > 0) {
                    request = String.valueOf(request) + "&CRITERIA=(" + criteria + ")";
                }
                parentContext = compoundFilteredContext.getParentContext();
            }
            if (parentContext instanceof ISystemParameterContext) {
                ISystemParameterContext systemParameterContext = (ISystemParameterContext)parentContext;
                request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode("PARMTYPE(" + systemParameterContext.getType() + ")", "UTF-8");
                request = String.valueOf(request) + "%20";
                request = String.valueOf(request) + URLEncoder.encode("PARMSRCE(" + systemParameterContext.getSource() + ")", "UTF-8");
                parentContext = systemParameterContext.getParentContext();
            }
            if (parentContext instanceof IGroupContext) {
                IGroupContext groupContext = (IGroupContext)parentContext;
                parentContext = groupContext.getParentContext();
                String groupName = groupContext.getResourceGroup();
                String parameterName = parentContext instanceof IScopedContext ? "CSDGROUP" : "RESGROUP";
                request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode(String.valueOf(parameterName) + "(" + groupName + ")", "UTF-8");
            } else if (parentContext instanceof IScopedContext && IResourceTables.Helper.isCICSDefinition((String)resourceType) && (scopedContext = (IScopedContext)parentContext).getScope() != null) {
                request = String.valueOf(request) + "&PARAMETER=CSDGROUP(*)";
            }
            if (parentContext instanceof IScopedContext) {
                scopedContext = (IScopedContext)parentContext;
                String scope = scopedContext.getScope();
                if (scope == null) {
                    scope = "";
                }
                request = "/" + URLEncoder.encode(scope, "UTF-8") + request;
            }
            if (this.requiresWorkloadParameter(resourceType)) {
                String workloadName = "*";
                Object workloadContext = null;
                if (parentContext instanceof IWorkloadContext) {
                    workloadName = ((IWorkloadContext)parentContext).getWorkloadName();
                } else if (context instanceof IWorkloadContext) {
                    workloadName = ((IWorkloadContext)context).getWorkloadName();
                }
                debug.event("buildGETRequest", workloadContext, (Object)workloadName);
                request = String.valueOf(request) + "&PARAMETER=WORKLOAD(" + workloadName + ")";
            }
            request = "/" + URLEncoder.encode(parentContext.getContext(), "UTF-8") + request;
            if (parentContext instanceof IDefinitionContext) {
                IDefinitionContext definitionContext = (IDefinitionContext)parentContext;
                String resourceGroup = definitionContext.getResourceGroup();
                debug.event("buildGETRequest", (Object)definitionContext, (Object)resourceGroup);
                if (resourceGroup != null) {
                    request = String.valueOf(request) + "&PARAMETER=" + URLEncoder.encode("RESGROUP(" + definitionContext.getResourceGroup() + ")", "UTF-8");
                }
            } else if (parentContext instanceof IAssociationContext) {
                IAssociationContext associationContext = (IAssociationContext)parentContext;
                String type = IModelNames.ModelNamesHelper.getModelName(associationContext.getResourceType());
                String name = associationContext.getResourceName();
                debug.event("buildGETRequest", (Object)associationContext, (Object)type, (Object)name);
                request = String.valueOf(request) + "&ASSOCIATION=" + URLEncoder.encode(String.valueOf(type) + "=" + name, "UTF-8");
            }
        }
        debug.exit("buildGETRequest", (Object)request);
        return request;
    }

    @Override
    public SMConnectionResponse fetch(String stub, int position, int count) throws SystemManagerConnectionException, AuthenticationException {
        debug.enter("fetch", (Object)this, (Object)stub, (Object)position, (Object)count);
        SMResponse response = null;
        if (!stub.equals("CMASLIST")) {
            response = (SMResponse)((Object)this.stubs.get(stub));
            if (response != null) {
                String resourceType = response.getResourceType();
                if (response.getResponse().equals("NODATA")) {
                    response = new SMResponse(stub, resourceType, new String[0], response.getContext());
                } else if (response.getRecordTotal() == 0) {
                    debug.event("fetch", (Object)response);
                    response = new SMResponse(stub, resourceType, new String[0], null);
                } else {
                    response = new SMResponse(response, position - 1, count);
                    this.vseConnectionBehaviour.modifyRecords(response);
                }
            } else {
                throw new SMConnectionException(stub);
            }
        }
        debug.exit("fetch", response);
        return response;
    }

    @Override
    protected String getVersionFromRegionRecord() {
        debug.enter("getVersionFromRegionRecord");
        String release = this.regionRecord.get("EYU_CICSREL");
        debug.event("getVersionFromRegionRecord", "EYU_CICSREL from CICS: " + release);
        if (release.equals(VSE_111_EYU_CICSREL)) {
            this.vseConnectionBehaviour = new VSE51ConnectionBehaviour();
            release = CICS_TS_41_EYU_CICSREL;
        } else if (release.equals(VSE_420_EYU_CICSREL)) {
            this.vseConnectionBehaviour = new VSE61ConnectionBehaviour();
            release = CICS_TS_42_EYU_CICSREL;
        } else {
            this.vseConnectionBehaviour = new VSEConnectionBehaviour();
        }
        debug.exit("getVersionFromRegionRecord", (Object)("Returning EYU_CICSREL: " + release));
        return release;
    }

    @Override
    public String getActions(String resourceName, IContext context) {
        debug.enter("getActions");
        String actions = this.vseConnectionBehaviour.getActions(resourceName, context);
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean supported = this.vseConnectionBehaviour.checkOperation(resourceType, context, operation);
        if (supported) {
            switch (operation.getOperationType()) {
                case GET: {
                    supported = this.checkGetOperation(resourceType, context, operation);
                    break;
                }
                case PERFORM: {
                    supported = super.checkOperation(resourceType, context, operation);
                    break;
                }
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    @Override
    public void discard(String stub) throws SMConnectionException {
        debug.enter("discard", (Object)this, (Object)stub);
        SMResponse smResponse = (SMResponse)((Object)this.stubs.remove(stub));
        debug.event("discard", (Object)smResponse);
        debug.exit("discard");
    }

    private boolean checkGetOperation(String resourceType, IContext context, ICICSOperation operation) {
        if (context instanceof OrderedContext || context instanceof IComplexFilteredContext || IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            return false;
        }
        return super.checkOperation(resourceType, context, operation);
    }
}

