/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.model.ICICSType;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Messages {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String BUNDLE_NAME = "com.ibm.cics.core.ui.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.cics.core.ui.messages");
    private static final Object[] EMPTY_INSERTS = new Object[0];
    private static final Logger logger = Logger.getLogger("com.ibm.cics.core.ui");

    private Messages() {
    }

    public static String getString(String key) {
        return Messages.getString(key, EMPTY_INSERTS);
    }

    public static String getString(String key, Object insert0) {
        return Messages.getString(key, new Object[]{insert0});
    }

    public static String getString(String key, Object insert0, Object insert1) {
        return Messages.getString(key, new Object[]{insert0, insert1});
    }

    public static String getString(String key, Object insert0, Object insert1, Object insert2) {
        return Messages.getString(key, new Object[]{insert0, insert1, insert2});
    }

    public static String getString(String key, Object[] inserts) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), inserts);
        }
        catch (MissingResourceException missingResourceException) {
            logger.log(Level.WARNING, "Missing property from resource bundle \"com.ibm.cics.core.ui.messages\"", key);
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getTableDescription(ICICSType<?> type) {
        return Messages.getTableDescription(type.getResourceTableName());
    }

    public static String getTableDescription(String tableName) {
        return TableDescriptions.getTableDescription((String)tableName);
    }

    public static String getTableDescriptionInLowercase(String tableName) {
        return TableDescriptions.getTableDescriptionInLowercase((String)tableName);
    }

    public static String getPluralTableDescription(String tableName) {
        return TableDescriptions.getPluralTableDescription((String)tableName);
    }

    public static String getPluralTableDescription(ICICSType<?> cicsType) {
        return TableDescriptions.getPluralTableDescription((String)cicsType.getResourceTableName());
    }
}

