/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.extra.IAdaptableTreeNode;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.adapters.AdapterUtility;
import com.ibm.cics.core.ui.decorators.LazyQueryCompositeImageDescriptor;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class SystemGroupParentTreeAdapter
implements IDeferredWorkbenchAdapter,
IAdaptable,
IAdaptableTreeNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SystemGroupParentTreeAdapter.class);
    private ICICSplex cicsPlex;
    private boolean hasChildren = true;
    private boolean errorState = false;

    public SystemGroupParentTreeAdapter(ICICSplex cicsplex) {
        this.cicsPlex = cicsplex;
    }

    public void setErrorState(boolean error) {
        this.errorState = error;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        Object imageDescriptor = UIPlugin.IMGD_SYSTEM_GROUP_DEFINITION;
        if (this.errorState) {
            ImageDescriptor error = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
            imageDescriptor = new LazyQueryCompositeImageDescriptor((ImageDescriptor)imageDescriptor, error);
        }
        return imageDescriptor;
    }

    public String getLabel(Object o) {
        return Messages.getString("SystemGroupParentTreeAdapter.system_groups");
    }

    public Object getParent(Object o) {
        return null;
    }

    public ICPSM getCPSM() {
        return null;
    }

    public Object getAdapter(Class adapterType) {
        debug.enter("getAdapter", (Object)this, (Object)adapterType);
        Object adapter = null;
        if (adapterType == IPropertySourceProvider.class) {
            adapter = new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    return null;
                }
            };
        } else if (adapterType == IWorkbenchAdapter.class) {
            adapter = this;
        }
        debug.exit("getAdapter", adapter);
        return adapter;
    }

    public void checkForChildren(IProgressMonitor monitor) throws CICSSystemManagerException {
        if (monitor.isCanceled()) {
            return;
        }
        this.hasChildren = false;
        ICPSM cpsm = ((ICoreObject)this.cicsPlex).getCPSM();
        Context context = new Context(this.cicsPlex.getName());
        SMConnectionResponse response = cpsm.get(CICSRegionGroupDefinitionType.getInstance().getResourceTableName(), (IContext)context);
        if (response.getRecordTotal() > 0) {
            this.hasChildren = true;
        }
        cpsm.discard(response.getStub());
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        debug.enter("fetchDeferredChildren", (Object)this, object, (Object)collector, (Object)monitor);
        monitor.beginTask("", -1);
        Context context = new Context(this.cicsPlex.getName());
        ICoreObject coreObject = (ICoreObject)this.cicsPlex;
        ICPSM cpsm = coreObject.getCPSM();
        AdapterUtility.getSystemGroups(collector, monitor, cpsm, (IContext)context);
        monitor.done();
        debug.exit("fetchDeferredChildren");
    }

    public boolean isContainer() {
        return this.hasChildren;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }
}

