/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IPlatformDefinition;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;

final class PlatformAppDefnsNodeDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(PlatformAppDefnsNodeDeferredWorkbenchAdapter.class);
    private final IPlatformDefinition platformDefinition;

    PlatformAppDefnsNodeDeferredWorkbenchAdapter(CloudInput anInput, IPlatformDefinition aPlatformDefinition) {
        super(anInput);
        DEBUG.enter("constructor", (Object)this, (Object)aPlatformDefinition);
        this.platformDefinition = aPlatformDefinition;
        DEBUG.exit("constructor");
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        DEBUG.enter("getLabel", (Object)this, o);
        String result = NLS.bind((String)CloudMessages.ApplicationsNodeName, null);
        DEBUG.exit("getLabel", (Object)result);
        return result;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        DEBUG.enter("getImageDescriptor", (Object)this, object);
        ImageDescriptor result = UIPlugin.IMGD_APPLICATION_GROUP;
        DEBUG.exit("getImageDescriptor", (Object)result);
        return result;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        Object[] applicationDefinitions;
        DEBUG.enter("getDataChildren", (Object)this, o);
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), ApplicationType.PLATFORM_DEFINITION_NAME, this.platformDefinition.getName());
        try {
            applicationDefinitions = this.getApplicationDefinitionsForPlatform(filteredContext);
        }
        catch (SystemManagerConnectionException e) {
            applicationDefinitions = new Object[]{new ErrorWrapper(e)};
        }
        DEBUG.exit("getDataChildren", (Object)applicationDefinitions);
        return applicationDefinitions;
    }

    private ICICSObject[] getApplicationDefinitionsForPlatform(FilteredContext filteredContext) throws SystemManagerConnectionException {
        ICICSObject[] results;
        block2: {
            DEBUG.enter("getApplicationDefinitionsForPlatform", (Object)this, (Object)filteredContext);
            results = new ICICSObject[]{};
            try {
                results = this.getCICSObjects((ICICSType<?>)ApplicationDefinitionType.getInstance(), (IContext)filteredContext);
            }
            catch (CICSSystemManagerException e) {
                DEBUG.event("getApplicationDefinitionsForPlatform", (Object)e);
                if (e.getCause() == null || !(e.getCause() instanceof SystemManagerConnectionException)) break block2;
                throw (SystemManagerConnectionException)e.getCause();
            }
        }
        DEBUG.exit("getApplicationDefinitionsForPlatform", (Object)results);
        return results;
    }

    public boolean isContainer() {
        return true;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        return "";
    }

    @Override
    protected String getFetchingName() {
        return NLS.bind((String)CloudMessages.AbstractCPSMDeferredWorkbenchAdapter_application_definitions, null);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.platformDefinition == null ? 0 : this.platformDefinition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformAppDefnsNodeDeferredWorkbenchAdapter other = (PlatformAppDefnsNodeDeferredWorkbenchAdapter)obj;
        return !(this.platformDefinition == null ? other.platformDefinition != null : !EqualityHelper.equals((ICICSObject)this.platformDefinition, (ICICSObject)other.platformDefinition));
    }
}

