/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import java.util.HashMap;
import java.util.Map;

public abstract class AttributePropertyHelper2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected IType<?> type;
    protected IAttributePropertyDescriptor[] descriptors = new IAttributePropertyDescriptor[0];
    protected Map<Object, IAttributePropertyDescriptor> descriptorMap = new HashMap<Object, IAttributePropertyDescriptor>();

    protected AttributePropertyHelper2(IType<?> aType) {
        this.type = aType;
        IAttribute[] iAttributeArray = this.type.attributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attribute = iAttributeArray[n2];
            IAttributePropertyDescriptor descriptor = this.createPropertyDescriptor(this.type, attribute, false);
            if (descriptor != null) {
                this.descriptorMap.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
        this.descriptors = new IAttributePropertyDescriptor[this.descriptorMap.size()];
        this.descriptorMap.values().toArray(this.descriptors);
    }

    public IType<?> getType() {
        return this.type;
    }

    public IAttributePropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public IAttributePropertyDescriptor getPropertyDescriptor(Object id) {
        return this.descriptorMap.get(id);
    }

    protected abstract IAttributePropertyDescriptor createPropertyDescriptor(IType<?> var1, IAttribute<?> var2, boolean var3);
}

