/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.views.AbstractResourcesView;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.model.ICICSEnum;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FilterControlContribution
extends ControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(FilterControlContribution.class);
    private IAttributePropertyDescriptor descriptor;
    private boolean permitted;
    private String value;
    private AbstractResourcesView.IPropertyValueEditor editor = null;
    private IAction filterAction;

    protected FilterControlContribution(IAttributePropertyDescriptor descriptor, boolean permitted, String value, IAction filterAction) {
        super(descriptor.getId().toString());
        this.descriptor = descriptor;
        this.permitted = permitted;
        this.value = value;
        this.filterAction = filterAction;
        debug.event("FilterControlContribution", (Object)descriptor, (Object)permitted, (Object)value);
    }

    protected Control createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)c.getLayout()).marginHeight = 0;
        Label label = new Label(c, 0);
        String text = this.descriptor.getDisplayName();
        String toolTipText = this.descriptor.getDescription();
        label.setText(String.valueOf(text) + ": ");
        label.setToolTipText(toolTipText);
        GridData labelData = new GridData(131072, 0x1000000, true, false);
        label.setLayoutData((Object)labelData);
        label.setEnabled(this.permitted);
        Class type = this.descriptor.getAttribute().getType();
        Control control = type.isEnum() ? this.createCombo(c, type, this.value) : this.createText(c);
        GridData controlData = new GridData(16384, 0x1000000, true, false);
        control.setLayoutData((Object)controlData);
        control.setEnabled(this.permitted);
        return c;
    }

    private Control createCombo(Composite parent, Class<?> type, String text) {
        final Combo combo = new Combo(parent, 12);
        ?[] values = type.getEnumConstants();
        combo.add("");
        ?[] objArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objArray[n2];
            ICICSEnum enumValue = (ICICSEnum)value;
            if (!enumValue.isSpecialValue() && String.valueOf(value).trim().length() != 0) {
                combo.add(String.valueOf(value));
            }
            ++n2;
        }
        debug.event("createCombo", (Object)this, (Object)text);
        int index = combo.indexOf(text);
        if (index != -1) {
            combo.select(index);
        }
        this.editor = new AbstractResourcesView.IPropertyValueEditor(){

            @Override
            public void setValue(String newValue) {
                combo.setText(newValue);
            }

            @Override
            public String getValue() {
                return FilterControlContribution.this.permitted && !combo.isDisposed() ? combo.getText() : "";
            }
        };
        combo.addSelectionListener((SelectionListener)new MySelectionAdapter(this.filterAction));
        return combo;
    }

    private Control createText(Composite parent) {
        Composite c = new Composite(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                Point p = super.computeSize(hint, hint2, changed);
                return new Point(64, p.y);
            }
        };
        c.setLayout((Layout)new FillLayout());
        final Text text = new Text(c, 132);
        debug.event("createText", (Object)this, (Object)this.value);
        if (this.value.length() > 0) {
            text.setText(this.value);
        }
        text.setToolTipText(Messages.getString("ResourcesView.filterText.tooltip", new Object[0]));
        TextInput.setAccessibleLabel((Text)text, (String)text.getToolTipText());
        text.addSelectionListener((SelectionListener)new MySelectionAdapter(this.filterAction));
        this.editor = new AbstractResourcesView.IPropertyValueEditor(){

            @Override
            public void setValue(String newValue) {
                text.setText(newValue);
            }

            @Override
            public String getValue() {
                return FilterControlContribution.this.permitted && !text.isDisposed() && !"".equals(text.getText().trim()) ? text.getText() : "";
            }
        };
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                FilterControlContribution.this.validateFilter();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return c;
    }

    public AbstractResourcesView.IPropertyValueEditor getValueEditor() {
        return this.editor;
    }

    public IAttributePropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    private void validateFilter() {
    }

    private class MySelectionAdapter
    extends SelectionAdapter {
        private IAction filterAction;

        public MySelectionAdapter(IAction filterAction) {
            this.filterAction = filterAction;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            boolean enabled = this.filterAction.isEnabled();
            debug.event("widgetDefaultSelected", (Object)this, (Object)e, (Object)enabled);
            if (enabled) {
                this.filterAction.run();
            }
        }
    }
}

