/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.views.BaseContextProvider;
import com.ibm.cics.core.ui.views.IBaseContextProvider;
import com.ibm.cics.core.ui.views.IDisposableSelectionProvider;
import com.ibm.cics.sm.comm.IContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionContextProvider
extends BaseContextProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final com.ibm.cics.common.util.Debug debug = new com.ibm.cics.common.util.Debug(SelectionContextProvider.class);
    final ISelectionChangedListener selectionListener;
    final IDisposableSelectionProvider selectionProvider;
    private IContext context;
    private String description;

    public SelectionContextProvider(IDisposableSelectionProvider selectionProvider, final IContextProviderAdapter contextProviderAdapter) {
        this.selectionProvider = selectionProvider;
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event == null) {
                    SelectionContextProvider.this.setContext(null);
                } else {
                    IContext context;
                    Object firstElement;
                    ISelection selection = event.getSelection();
                    if (Debug.DEBUG_SELECTION) {
                        debug.enter("selectionChanged", (Object)("selection=" + selection));
                    }
                    if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null && (context = contextProviderAdapter.getContextFor(firstElement)) != null) {
                        SelectionContextProvider.this.setContext(context);
                    }
                }
                if (Debug.DEBUG_SELECTION) {
                    debug.exit("selectionChanged");
                }
            }
        };
        selectionProvider.addSelectionChangedListener(this.selectionListener);
        ISelection initialSelection = selectionProvider.getSelection();
        if (initialSelection != null) {
            this.selectionListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)selectionProvider, initialSelection));
        }
    }

    private void setContext(IContext newContext) {
        debug.enter("setContext", (Object)this, (Object)newContext);
        if (this.isDifferentContext(newContext)) {
            this.context = newContext;
            this.description = ExceptionMessageHelper.getContextOrScopeNameFor(this.context);
            this.eventManager.notifyListeners((Object)new IBaseContextProvider.ContextChangedEvent(this.context, this.description));
        }
        debug.exit("setContext");
    }

    private boolean isDifferentContext(IContext newContext) {
        if (newContext == null) {
            return this.context != null;
        }
        if (this.context == null) {
            return true;
        }
        if (!newContext.getClass().equals(this.context.getClass())) {
            return true;
        }
        return !newContext.equals(this.context);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.selectionProvider.removeSelectionChangedListener(this.selectionListener);
        this.selectionProvider.dispose();
    }

    @Override
    public IContext getContext() {
        return this.context;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static interface IContextProviderAdapter {
        public IContext getContextFor(Object var1);
    }
}

