/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.FilterData;
import com.ibm.cics.sm.comm.FilterLogic;
import com.ibm.cics.sm.comm.FilterLogicMultipleOperands;
import com.ibm.cics.sm.comm.FilterLogicSingleOperand;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IComplexFilterVisitor;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.InvalidFilterException;
import com.ibm.cics.sm.comm.sm.internal.IOperationRule;
import java.util.List;

public class ComplexFilterOperatorRule
implements IOperationRule {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    public boolean matches(String resourceType, IContext context, ICICSOperation operation) {
        return operation.getOperationType() == ICICSOperation.OperationType.GET && context instanceof IComplexFilteredContext;
    }

    @Override
    public boolean passes(String resourceType, IContext context, ICICSOperation operation) {
        try {
            this.getCriteriaFromComplexFilteredContext((IComplexFilteredContext)context);
        }
        catch (InvalidFilterException invalidFilterException) {
            return false;
        }
        return true;
    }

    public String getCriteriaFromComplexFilteredContext(IComplexFilteredContext complexFilteredContext) throws InvalidFilterException {
        IComplexFilterVisitor<String> basicStringRenderer = new IComplexFilterVisitor<String>(){

            public String visit(FilterData<?> filterData) throws InvalidFilterException {
                return "(" + filterData.getFilterField().toString() + this.convert(filterData.getFilterOperator()) + "'" + filterData.getFilterString().replace("'", "''") + "')";
            }

            public String visit(FilterLogicMultipleOperands multipleOperandLogic, List<String> childResults) throws InvalidFilterException {
                StringBuffer result = new StringBuffer();
                result.append("(");
                int i = 0;
                while (i < childResults.size()) {
                    result.append(childResults.get(i));
                    if (i < childResults.size() - 1) {
                        result.append("%20");
                        result.append(this.convert(multipleOperandLogic.getType()));
                        result.append("%20");
                    }
                    ++i;
                }
                result.append(")");
                return result.toString();
            }

            public String visit(FilterLogicSingleOperand singleOperandLogic, String childResult) throws InvalidFilterException {
                if (singleOperandLogic.getType() == FilterLogic.LogicOperator.IS) {
                    return childResult;
                }
                return "(NOT%20" + childResult + ")";
            }

            private String convert(FilterLogic.LogicOperator op) throws InvalidFilterException {
                switch (op) {
                    case AND: {
                        return "AND";
                    }
                    case IS: {
                        return "";
                    }
                    case NOT: {
                        return "NOT";
                    }
                    case OR: {
                        return "OR";
                    }
                }
                throw new InvalidFilterException("Unhandled operator: " + op);
            }

            private String convert(FilterData.FilterOperator op) throws InvalidFilterException {
                switch (op) {
                    case EQUALS: {
                        return "=";
                    }
                    case GREATER_THAN: {
                        return ">";
                    }
                    case GREATER_THAN_EQUAL: {
                        return ">=";
                    }
                    case LESS_THAN: {
                        return "<";
                    }
                    case LESS_THAN_EQUAL: {
                        return "<=";
                    }
                    case NOT_EQUAL: {
                        return "\u00ac=";
                    }
                    case SAME: {
                        return "==";
                    }
                }
                throw new InvalidFilterException("Unhandled operator: " + op);
            }
        };
        return (String)complexFilteredContext.getFilterExpression().accept((IComplexFilterVisitor)basicStringRenderer);
    }
}

