/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.connections.ConnectionParameters;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public interface IConnectionProvider {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getId();

    public ConnectionParameters getConnection(String var1);

    public Collection<ConnectionParameters> getConnections();

    public void addListener(ConnectionProviderListener var1);

    public IStatus refresh(IProgressMonitor var1);

    public String getDescription();

    public static class ConnectionParametersAddedEvent
    extends ConnectionProviderConnectionParametersEvent {
        public ConnectionParametersAddedEvent(ConnectionParameters configuration) {
            super(configuration);
        }
    }

    public static class ConnectionParametersRemovedEvent
    extends ConnectionProviderConnectionParametersEvent {
        public ConnectionParametersRemovedEvent(ConnectionParameters configuration) {
            super(configuration);
        }
    }

    public static class ConnectionParametersUpdatedEvent
    extends ConnectionProviderConnectionParametersEvent {
        private ConnectionParameters oldConfiguration;

        public ConnectionParametersUpdatedEvent(ConnectionParameters oldParameters, ConnectionParameters newParameters) {
            super(newParameters);
            this.oldConfiguration = oldParameters;
        }

        public ConnectionParameters getOldConnectionParameters() {
            return this.oldConfiguration;
        }
    }

    public static abstract class ConnectionProviderConnectionParametersEvent
    extends ConnectionProviderEvent {
        private ConnectionParameters connectionParameters;

        public ConnectionProviderConnectionParametersEvent(ConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
        }

        public ConnectionParameters getConnectionParameters() {
            return this.connectionParameters;
        }
    }

    public static abstract class ConnectionProviderEvent {
    }

    public static abstract class ConnectionProviderListener
    extends StaleableEventListener<ConnectionProviderEvent> {
    }

    public static class ConnectionProviderStaleEvent
    extends ConnectionProviderEvent {
    }

    public static class ConnectionProviderStatusChangedEvent
    extends ConnectionProviderEvent {
        private IStatus status;

        public ConnectionProviderStatusChangedEvent(IStatus status) {
            this.status = status;
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

