/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionsXMLSerializer;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class OldConnectionReader
implements IConnectionDeserializer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CONFIG_NAME = "CONFIG_NAME";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String PORT_NAME = "PORT_NAME";
    public static final String OVERRIDE_SSL = "OVERRIDE_SSL";
    public static final String CREDENTIAL_ID = "CREDENTIAL_ID";
    private static final Debug debug = new Debug(OldConnectionReader.class);
    private final Preferences connectionsNode;
    private final boolean invertSSL;

    public OldConnectionReader(Preferences connectionsNode, boolean invertSSL) {
        this.connectionsNode = connectionsNode;
        this.invertSSL = invertSSL;
    }

    @Override
    public List<ConnectionParameters> load() throws IOException {
        HashMap<String, List<ConnectionConfiguration>> connectionTypeIdToConnectionConfiguration = new HashMap<String, List<ConnectionConfiguration>>();
        try {
            String[] stringArray = this.connectionsNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String connectionTypeId = stringArray[n2];
                Preferences typeNode = this.connectionsNode.node(connectionTypeId);
                String[] connectionIDs = typeNode.childrenNames();
                ArrayList<ConnectionConfiguration> connectionConfigurations = new ArrayList<ConnectionConfiguration>();
                String[] stringArray2 = connectionIDs;
                int n3 = connectionIDs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String connectionID = stringArray2[n4];
                    Preferences connectionConfigurationNode = typeNode.node(connectionID);
                    ConnectionConfiguration connectionConfiguration = new ConfigurationReader(connectionID, connectionConfigurationNode, this.invertSSL).readConfiguration();
                    if (connectionConfiguration != null) {
                        connectionConfigurations.add(connectionConfiguration);
                    }
                    ++n4;
                }
                if (connectionConfigurations.size() > 0) {
                    connectionTypeIdToConnectionConfiguration.put(connectionTypeId, connectionConfigurations);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            debug.warning("getConnectionConfigurations", (Object)e);
            throw new IOException();
        }
        return this.parameterify(connectionTypeIdToConnectionConfiguration);
    }

    private List<ConnectionParameters> parameterify(Map<String, List<ConnectionConfiguration>> connectionTypeIdToConnectionConfiguration) {
        ArrayList<ConnectionParameters> list = new ArrayList<ConnectionParameters>();
        for (Map.Entry<String, List<ConnectionConfiguration>> entry : connectionTypeIdToConnectionConfiguration.entrySet()) {
            String connectionTypeId = entry.getKey();
            for (ConnectionConfiguration connectionConfiguration : entry.getValue()) {
                list.add(new ConnectionParameters(connectionConfiguration.getID(), connectionConfiguration.getName(), connectionTypeId, this.getAttributes(connectionConfiguration)));
            }
        }
        ConnectionsXMLSerializer.fixDuplicateIDs(list);
        return list;
    }

    private Map<String, String> getAttributes(ConnectionConfiguration connectionConfiguration) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("host", connectionConfiguration.getHost());
        attributes.put("port", String.valueOf(connectionConfiguration.getPort()));
        attributes.put("ATTEMPT_SECURE", String.valueOf(connectionConfiguration.getSecureHint()));
        attributes.put("ssl_confirmed", String.valueOf(connectionConfiguration.isSSLConfirmed()));
        for (String key : connectionConfiguration.getExtendedKeys()) {
            attributes.put(key, connectionConfiguration.getExtendedAttribute(key));
        }
        return attributes;
    }

    private static class ConfigurationReader {
        private static final Set<String> nonExtendedKeys;
        private final Set<String> keys = new HashSet<String>();
        private final Preferences connectionConfigurationNode;
        private final String connectionID;
        private final boolean invertSSL;

        static {
            HashSet<String> keys = new HashSet<String>();
            keys.add(OldConnectionReader.CONFIG_NAME);
            keys.add(OldConnectionReader.SERVER_NAME);
            keys.add(OldConnectionReader.PORT_NAME);
            keys.add(OldConnectionReader.CREDENTIAL_ID);
            keys.add(OldConnectionReader.OVERRIDE_SSL);
            keys.add("CONFIRM_SSL");
            nonExtendedKeys = Collections.unmodifiableSet(keys);
        }

        public ConfigurationReader(String connectionID, Preferences connectionConfigurationNode, boolean invertSSL) {
            this.connectionID = connectionID;
            this.connectionConfigurationNode = connectionConfigurationNode;
            this.invertSSL = invertSSL;
            try {
                this.keys.addAll(Arrays.asList(connectionConfigurationNode.keys()));
            }
            catch (BackingStoreException ex) {
                debug.warning("readConfiguration", "Exception trying to read ssl override", (Throwable)ex);
            }
        }

        public ConnectionConfiguration readConfiguration() {
            String credentialID;
            int port;
            String host;
            String configName = this.readPreference(OldConnectionReader.CONFIG_NAME);
            if (configName == null) {
                debug.warning("readConfiguration", (Object)"config name was null", (Object)("connectionConfigurationId=" + this.connectionID));
            }
            if ((host = this.readPreference(OldConnectionReader.SERVER_NAME)) == null) {
                debug.warning("readConfiguration", (Object)"host was null", (Object)("connectionConfigurationId=" + this.connectionID));
            }
            try {
                port = Integer.parseInt(this.readPreference(OldConnectionReader.PORT_NAME));
            }
            catch (NumberFormatException numberFormatException) {
                port = -1;
            }
            if (port == -1) {
                debug.warning("readConfiguration", (Object)"port was invalid", (Object)("connectionConfigurationId=" + this.connectionID));
            }
            if ((credentialID = this.readPreference(OldConnectionReader.CREDENTIAL_ID)) == null) {
                credentialID = "";
            }
            if (configName == null || host == null || port == -1) {
                return null;
            }
            ConnectionConfiguration configuration = new ConnectionConfiguration(this.connectionID, configName, host, port, credentialID);
            int secureConfirmed = this.connectionConfigurationNode.getInt("CONFIRM_SSL", 0);
            if (secureConfirmed != 0) {
                configuration.setSecureHint(secureConfirmed > 0);
                configuration.setSslConfirmation(true);
            } else {
                boolean secureOverride = Boolean.parseBoolean(this.readPreference(OldConnectionReader.OVERRIDE_SSL));
                configuration.setSecureHint(this.invertSSL ^ secureOverride);
                configuration.setSslConfirmation(false);
            }
            for (String key : this.getExtendedKeys(this.keys)) {
                String value = this.readPreference(key);
                if (value != null) {
                    configuration.setExtendedAttribute(key, value);
                    continue;
                }
                debug.warning("readConfiguration", (Object)"couldn't read param", (Object)("param=" + key));
            }
            return configuration;
        }

        private List<String> getExtendedKeys(Collection<String> keys) {
            return CollectionUtils.filter(keys, new Function<String, Boolean>(){

                @Override
                public Boolean evaluate(String key) {
                    return !nonExtendedKeys.contains(key);
                }
            });
        }

        private String readPreference(String key) {
            String value = this.connectionConfigurationNode.get(key, null);
            this.keys.remove(value);
            return value;
        }
    }
}

